/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class CommonDataServiceForAppsLinkedServiceTypeProperties
implements JsonSerializable<CommonDataServiceForAppsLinkedServiceTypeProperties> {
    private Object deploymentType;
    private Object hostname;
    private Object port;
    private Object serviceUri;
    private Object organizationName;
    private Object authenticationType;
    private Object domain;
    private Object username;
    private SecretBase password;
    private Object servicePrincipalId;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalCredential;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(CommonDataServiceForAppsLinkedServiceTypeProperties.class);

    public Object deploymentType() {
        return this.deploymentType;
    }

    public CommonDataServiceForAppsLinkedServiceTypeProperties withDeploymentType(Object deploymentType) {
        this.deploymentType = deploymentType;
        return this;
    }

    public Object hostname() {
        return this.hostname;
    }

    public CommonDataServiceForAppsLinkedServiceTypeProperties withHostname(Object hostname) {
        this.hostname = hostname;
        return this;
    }

    public Object port() {
        return this.port;
    }

    public CommonDataServiceForAppsLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    public Object serviceUri() {
        return this.serviceUri;
    }

    public CommonDataServiceForAppsLinkedServiceTypeProperties withServiceUri(Object serviceUri) {
        this.serviceUri = serviceUri;
        return this;
    }

    public Object organizationName() {
        return this.organizationName;
    }

    public CommonDataServiceForAppsLinkedServiceTypeProperties withOrganizationName(Object organizationName) {
        this.organizationName = organizationName;
        return this;
    }

    public Object authenticationType() {
        return this.authenticationType;
    }

    public CommonDataServiceForAppsLinkedServiceTypeProperties withAuthenticationType(Object authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object domain() {
        return this.domain;
    }

    public CommonDataServiceForAppsLinkedServiceTypeProperties withDomain(Object domain) {
        this.domain = domain;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public CommonDataServiceForAppsLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public CommonDataServiceForAppsLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public CommonDataServiceForAppsLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public Object servicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public CommonDataServiceForAppsLinkedServiceTypeProperties withServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase servicePrincipalCredential() {
        return this.servicePrincipalCredential;
    }

    public CommonDataServiceForAppsLinkedServiceTypeProperties withServicePrincipalCredential(SecretBase servicePrincipalCredential) {
        this.servicePrincipalCredential = servicePrincipalCredential;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public CommonDataServiceForAppsLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.deploymentType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property deploymentType in model CommonDataServiceForAppsLinkedServiceTypeProperties"));
        }
        if (this.authenticationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property authenticationType in model CommonDataServiceForAppsLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
        if (this.servicePrincipalCredential() != null) {
            this.servicePrincipalCredential().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("deploymentType", this.deploymentType);
        jsonWriter.writeUntypedField("authenticationType", this.authenticationType);
        jsonWriter.writeUntypedField("hostName", this.hostname);
        jsonWriter.writeUntypedField("port", this.port);
        jsonWriter.writeUntypedField("serviceUri", this.serviceUri);
        jsonWriter.writeUntypedField("organizationName", this.organizationName);
        jsonWriter.writeUntypedField("domain", this.domain);
        jsonWriter.writeUntypedField("username", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
        jsonWriter.writeJsonField("servicePrincipalCredential", (JsonSerializable)this.servicePrincipalCredential);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static CommonDataServiceForAppsLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CommonDataServiceForAppsLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            CommonDataServiceForAppsLinkedServiceTypeProperties deserializedCommonDataServiceForAppsLinkedServiceTypeProperties = new CommonDataServiceForAppsLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("deploymentType".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsLinkedServiceTypeProperties.deploymentType = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsLinkedServiceTypeProperties.authenticationType = reader.readUntyped();
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsLinkedServiceTypeProperties.hostname = reader.readUntyped();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsLinkedServiceTypeProperties.port = reader.readUntyped();
                    continue;
                }
                if ("serviceUri".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsLinkedServiceTypeProperties.serviceUri = reader.readUntyped();
                    continue;
                }
                if ("organizationName".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsLinkedServiceTypeProperties.organizationName = reader.readUntyped();
                    continue;
                }
                if ("domain".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsLinkedServiceTypeProperties.domain = reader.readUntyped();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalCredentialType".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsLinkedServiceTypeProperties.servicePrincipalCredentialType = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalCredential".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsLinkedServiceTypeProperties.servicePrincipalCredential = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedCommonDataServiceForAppsLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCommonDataServiceForAppsLinkedServiceTypeProperties;
        });
    }
}

