/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class CassandraLinkedServiceTypeProperties
implements JsonSerializable<CassandraLinkedServiceTypeProperties> {
    private Object host;
    private Object authenticationType;
    private Object port;
    private Object username;
    private SecretBase password;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(CassandraLinkedServiceTypeProperties.class);

    public Object host() {
        return this.host;
    }

    public CassandraLinkedServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    public Object authenticationType() {
        return this.authenticationType;
    }

    public CassandraLinkedServiceTypeProperties withAuthenticationType(Object authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object port() {
        return this.port;
    }

    public CassandraLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public CassandraLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public CassandraLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public CassandraLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.host() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property host in model CassandraLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("host", this.host);
        jsonWriter.writeUntypedField("authenticationType", this.authenticationType);
        jsonWriter.writeUntypedField("port", this.port);
        jsonWriter.writeUntypedField("username", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static CassandraLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CassandraLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            CassandraLinkedServiceTypeProperties deserializedCassandraLinkedServiceTypeProperties = new CassandraLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("host".equals(fieldName)) {
                    deserializedCassandraLinkedServiceTypeProperties.host = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedCassandraLinkedServiceTypeProperties.authenticationType = reader.readUntyped();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedCassandraLinkedServiceTypeProperties.port = reader.readUntyped();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedCassandraLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedCassandraLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedCassandraLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCassandraLinkedServiceTypeProperties;
        });
    }
}

