/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class AzureFileStorageLinkedServiceTypeProperties
implements JsonSerializable<AzureFileStorageLinkedServiceTypeProperties> {
    private Object host;
    private Object userId;
    private SecretBase password;
    private Object connectionString;
    private AzureKeyVaultSecretReference accountKey;
    private Object sasUri;
    private AzureKeyVaultSecretReference sasToken;
    private Object fileShare;
    private Object snapshot;
    private String encryptedCredential;
    private Object serviceEndpoint;
    private CredentialReference credential;

    public Object host() {
        return this.host;
    }

    public AzureFileStorageLinkedServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    public Object userId() {
        return this.userId;
    }

    public AzureFileStorageLinkedServiceTypeProperties withUserId(Object userId) {
        this.userId = userId;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public AzureFileStorageLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object connectionString() {
        return this.connectionString;
    }

    public AzureFileStorageLinkedServiceTypeProperties withConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public AzureKeyVaultSecretReference accountKey() {
        return this.accountKey;
    }

    public AzureFileStorageLinkedServiceTypeProperties withAccountKey(AzureKeyVaultSecretReference accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    public Object sasUri() {
        return this.sasUri;
    }

    public AzureFileStorageLinkedServiceTypeProperties withSasUri(Object sasUri) {
        this.sasUri = sasUri;
        return this;
    }

    public AzureKeyVaultSecretReference sasToken() {
        return this.sasToken;
    }

    public AzureFileStorageLinkedServiceTypeProperties withSasToken(AzureKeyVaultSecretReference sasToken) {
        this.sasToken = sasToken;
        return this;
    }

    public Object fileShare() {
        return this.fileShare;
    }

    public AzureFileStorageLinkedServiceTypeProperties withFileShare(Object fileShare) {
        this.fileShare = fileShare;
        return this;
    }

    public Object snapshot() {
        return this.snapshot;
    }

    public AzureFileStorageLinkedServiceTypeProperties withSnapshot(Object snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureFileStorageLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object serviceEndpoint() {
        return this.serviceEndpoint;
    }

    public AzureFileStorageLinkedServiceTypeProperties withServiceEndpoint(Object serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public AzureFileStorageLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public void validate() {
        if (this.password() != null) {
            this.password().validate();
        }
        if (this.accountKey() != null) {
            this.accountKey().validate();
        }
        if (this.sasToken() != null) {
            this.sasToken().validate();
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("host", this.host);
        jsonWriter.writeUntypedField("userId", this.userId);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeUntypedField("connectionString", this.connectionString);
        jsonWriter.writeJsonField("accountKey", (JsonSerializable)this.accountKey);
        jsonWriter.writeUntypedField("sasUri", this.sasUri);
        jsonWriter.writeJsonField("sasToken", (JsonSerializable)this.sasToken);
        jsonWriter.writeUntypedField("fileShare", this.fileShare);
        jsonWriter.writeUntypedField("snapshot", this.snapshot);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeUntypedField("serviceEndpoint", this.serviceEndpoint);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        return jsonWriter.writeEndObject();
    }

    public static AzureFileStorageLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureFileStorageLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureFileStorageLinkedServiceTypeProperties deserializedAzureFileStorageLinkedServiceTypeProperties = new AzureFileStorageLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("host".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedServiceTypeProperties.host = reader.readUntyped();
                    continue;
                }
                if ("userId".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedServiceTypeProperties.userId = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("connectionString".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedServiceTypeProperties.connectionString = reader.readUntyped();
                    continue;
                }
                if ("accountKey".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedServiceTypeProperties.accountKey = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("sasUri".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedServiceTypeProperties.sasUri = reader.readUntyped();
                    continue;
                }
                if ("sasToken".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedServiceTypeProperties.sasToken = AzureKeyVaultSecretReference.fromJson(reader);
                    continue;
                }
                if ("fileShare".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedServiceTypeProperties.fileShare = reader.readUntyped();
                    continue;
                }
                if ("snapshot".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedServiceTypeProperties.snapshot = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("serviceEndpoint".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedServiceTypeProperties.serviceEndpoint = reader.readUntyped();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedAzureFileStorageLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureFileStorageLinkedServiceTypeProperties;
        });
    }
}

