/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class AzureDatabricksDetltaLakeLinkedServiceTypeProperties
implements JsonSerializable<AzureDatabricksDetltaLakeLinkedServiceTypeProperties> {
    private Object domain;
    private SecretBase accessToken;
    private Object clusterId;
    private String encryptedCredential;
    private CredentialReference credential;
    private Object workspaceResourceId;
    private static final ClientLogger LOGGER = new ClientLogger(AzureDatabricksDetltaLakeLinkedServiceTypeProperties.class);

    public Object domain() {
        return this.domain;
    }

    public AzureDatabricksDetltaLakeLinkedServiceTypeProperties withDomain(Object domain) {
        this.domain = domain;
        return this;
    }

    public SecretBase accessToken() {
        return this.accessToken;
    }

    public AzureDatabricksDetltaLakeLinkedServiceTypeProperties withAccessToken(SecretBase accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public Object clusterId() {
        return this.clusterId;
    }

    public AzureDatabricksDetltaLakeLinkedServiceTypeProperties withClusterId(Object clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureDatabricksDetltaLakeLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public CredentialReference credential() {
        return this.credential;
    }

    public AzureDatabricksDetltaLakeLinkedServiceTypeProperties withCredential(CredentialReference credential) {
        this.credential = credential;
        return this;
    }

    public Object workspaceResourceId() {
        return this.workspaceResourceId;
    }

    public AzureDatabricksDetltaLakeLinkedServiceTypeProperties withWorkspaceResourceId(Object workspaceResourceId) {
        this.workspaceResourceId = workspaceResourceId;
        return this;
    }

    public void validate() {
        if (this.domain() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property domain in model AzureDatabricksDetltaLakeLinkedServiceTypeProperties"));
        }
        if (this.accessToken() != null) {
            this.accessToken().validate();
        }
        if (this.credential() != null) {
            this.credential().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("domain", this.domain);
        jsonWriter.writeJsonField("accessToken", (JsonSerializable)this.accessToken);
        jsonWriter.writeUntypedField("clusterId", this.clusterId);
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        jsonWriter.writeJsonField("credential", (JsonSerializable)this.credential);
        jsonWriter.writeUntypedField("workspaceResourceId", this.workspaceResourceId);
        return jsonWriter.writeEndObject();
    }

    public static AzureDatabricksDetltaLakeLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDatabricksDetltaLakeLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureDatabricksDetltaLakeLinkedServiceTypeProperties deserializedAzureDatabricksDetltaLakeLinkedServiceTypeProperties = new AzureDatabricksDetltaLakeLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("domain".equals(fieldName)) {
                    deserializedAzureDatabricksDetltaLakeLinkedServiceTypeProperties.domain = reader.readUntyped();
                    continue;
                }
                if ("accessToken".equals(fieldName)) {
                    deserializedAzureDatabricksDetltaLakeLinkedServiceTypeProperties.accessToken = SecretBase.fromJson(reader);
                    continue;
                }
                if ("clusterId".equals(fieldName)) {
                    deserializedAzureDatabricksDetltaLakeLinkedServiceTypeProperties.clusterId = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAzureDatabricksDetltaLakeLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                if ("credential".equals(fieldName)) {
                    deserializedAzureDatabricksDetltaLakeLinkedServiceTypeProperties.credential = CredentialReference.fromJson(reader);
                    continue;
                }
                if ("workspaceResourceId".equals(fieldName)) {
                    deserializedAzureDatabricksDetltaLakeLinkedServiceTypeProperties.workspaceResourceId = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureDatabricksDetltaLakeLinkedServiceTypeProperties;
        });
    }
}

