/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DatasetCompression;
import com.azure.resourcemanager.datafactory.models.DatasetStorageFormat;
import java.io.IOException;

public final class AzureBlobDatasetTypeProperties
implements JsonSerializable<AzureBlobDatasetTypeProperties> {
    private Object folderPath;
    private Object tableRootLocation;
    private Object fileName;
    private Object modifiedDatetimeStart;
    private Object modifiedDatetimeEnd;
    private DatasetStorageFormat format;
    private DatasetCompression compression;

    public Object folderPath() {
        return this.folderPath;
    }

    public AzureBlobDatasetTypeProperties withFolderPath(Object folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    public Object tableRootLocation() {
        return this.tableRootLocation;
    }

    public AzureBlobDatasetTypeProperties withTableRootLocation(Object tableRootLocation) {
        this.tableRootLocation = tableRootLocation;
        return this;
    }

    public Object fileName() {
        return this.fileName;
    }

    public AzureBlobDatasetTypeProperties withFileName(Object fileName) {
        this.fileName = fileName;
        return this;
    }

    public Object modifiedDatetimeStart() {
        return this.modifiedDatetimeStart;
    }

    public AzureBlobDatasetTypeProperties withModifiedDatetimeStart(Object modifiedDatetimeStart) {
        this.modifiedDatetimeStart = modifiedDatetimeStart;
        return this;
    }

    public Object modifiedDatetimeEnd() {
        return this.modifiedDatetimeEnd;
    }

    public AzureBlobDatasetTypeProperties withModifiedDatetimeEnd(Object modifiedDatetimeEnd) {
        this.modifiedDatetimeEnd = modifiedDatetimeEnd;
        return this;
    }

    public DatasetStorageFormat format() {
        return this.format;
    }

    public AzureBlobDatasetTypeProperties withFormat(DatasetStorageFormat format) {
        this.format = format;
        return this;
    }

    public DatasetCompression compression() {
        return this.compression;
    }

    public AzureBlobDatasetTypeProperties withCompression(DatasetCompression compression) {
        this.compression = compression;
        return this;
    }

    public void validate() {
        if (this.format() != null) {
            this.format().validate();
        }
        if (this.compression() != null) {
            this.compression().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("folderPath", this.folderPath);
        jsonWriter.writeUntypedField("tableRootLocation", this.tableRootLocation);
        jsonWriter.writeUntypedField("fileName", this.fileName);
        jsonWriter.writeUntypedField("modifiedDatetimeStart", this.modifiedDatetimeStart);
        jsonWriter.writeUntypedField("modifiedDatetimeEnd", this.modifiedDatetimeEnd);
        jsonWriter.writeJsonField("format", (JsonSerializable)this.format);
        jsonWriter.writeJsonField("compression", (JsonSerializable)this.compression);
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobDatasetTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobDatasetTypeProperties)jsonReader.readObject(reader -> {
            AzureBlobDatasetTypeProperties deserializedAzureBlobDatasetTypeProperties = new AzureBlobDatasetTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("folderPath".equals(fieldName)) {
                    deserializedAzureBlobDatasetTypeProperties.folderPath = reader.readUntyped();
                    continue;
                }
                if ("tableRootLocation".equals(fieldName)) {
                    deserializedAzureBlobDatasetTypeProperties.tableRootLocation = reader.readUntyped();
                    continue;
                }
                if ("fileName".equals(fieldName)) {
                    deserializedAzureBlobDatasetTypeProperties.fileName = reader.readUntyped();
                    continue;
                }
                if ("modifiedDatetimeStart".equals(fieldName)) {
                    deserializedAzureBlobDatasetTypeProperties.modifiedDatetimeStart = reader.readUntyped();
                    continue;
                }
                if ("modifiedDatetimeEnd".equals(fieldName)) {
                    deserializedAzureBlobDatasetTypeProperties.modifiedDatetimeEnd = reader.readUntyped();
                    continue;
                }
                if ("format".equals(fieldName)) {
                    deserializedAzureBlobDatasetTypeProperties.format = DatasetStorageFormat.fromJson(reader);
                    continue;
                }
                if ("compression".equals(fieldName)) {
                    deserializedAzureBlobDatasetTypeProperties.compression = DatasetCompression.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureBlobDatasetTypeProperties;
        });
    }
}

