/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dashboard.DashboardManager;
import com.azure.resourcemanager.dashboard.fluent.PrivateLinkResourcesClient;
import com.azure.resourcemanager.dashboard.fluent.models.PrivateLinkResourceInner;
import com.azure.resourcemanager.dashboard.implementation.PrivateLinkResourceImpl;
import com.azure.resourcemanager.dashboard.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dashboard.models.PrivateLinkResource;
import com.azure.resourcemanager.dashboard.models.PrivateLinkResources;

public final class PrivateLinkResourcesImpl
implements PrivateLinkResources {
    private static final ClientLogger LOGGER = new ClientLogger(PrivateLinkResourcesImpl.class);
    private final PrivateLinkResourcesClient innerClient;
    private final DashboardManager serviceManager;

    public PrivateLinkResourcesImpl(PrivateLinkResourcesClient innerClient, DashboardManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<PrivateLinkResource> getWithResponse(String resourceGroupName, String workspaceName, String privateLinkResourceName, Context context) {
        Response<PrivateLinkResourceInner> inner = this.serviceClient().getWithResponse(resourceGroupName, workspaceName, privateLinkResourceName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new PrivateLinkResourceImpl((PrivateLinkResourceInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PrivateLinkResource get(String resourceGroupName, String workspaceName, String privateLinkResourceName) {
        PrivateLinkResourceInner inner = this.serviceClient().get(resourceGroupName, workspaceName, privateLinkResourceName);
        if (inner != null) {
            return new PrivateLinkResourceImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<PrivateLinkResource> list(String resourceGroupName, String workspaceName) {
        PagedIterable<PrivateLinkResourceInner> inner = this.serviceClient().list(resourceGroupName, workspaceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<PrivateLinkResource> list(String resourceGroupName, String workspaceName, Context context) {
        PagedIterable<PrivateLinkResourceInner> inner = this.serviceClient().list(resourceGroupName, workspaceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PrivateLinkResourceImpl((PrivateLinkResourceInner)((Object)inner1), this.manager()));
    }

    private PrivateLinkResourcesClient serviceClient() {
        return this.innerClient;
    }

    private DashboardManager manager() {
        return this.serviceManager;
    }
}

