/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dashboard.DashboardManager;
import com.azure.resourcemanager.dashboard.fluent.ManagedDashboardsClient;
import com.azure.resourcemanager.dashboard.fluent.models.ManagedDashboardInner;
import com.azure.resourcemanager.dashboard.implementation.ManagedDashboardImpl;
import com.azure.resourcemanager.dashboard.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dashboard.models.ManagedDashboard;
import com.azure.resourcemanager.dashboard.models.ManagedDashboards;

public final class ManagedDashboardsImpl
implements ManagedDashboards {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedDashboardsImpl.class);
    private final ManagedDashboardsClient innerClient;
    private final DashboardManager serviceManager;

    public ManagedDashboardsImpl(ManagedDashboardsClient innerClient, DashboardManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ManagedDashboard> getByResourceGroupWithResponse(String resourceGroupName, String dashboardName, Context context) {
        Response<ManagedDashboardInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, dashboardName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ManagedDashboardImpl((ManagedDashboardInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ManagedDashboard getByResourceGroup(String resourceGroupName, String dashboardName) {
        ManagedDashboardInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, dashboardName);
        if (inner != null) {
            return new ManagedDashboardImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<Void> deleteByResourceGroupWithResponse(String resourceGroupName, String dashboardName, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, dashboardName, context);
    }

    @Override
    public void deleteByResourceGroup(String resourceGroupName, String dashboardName) {
        this.serviceClient().delete(resourceGroupName, dashboardName);
    }

    @Override
    public PagedIterable<ManagedDashboard> listByResourceGroup(String resourceGroupName) {
        PagedIterable<ManagedDashboardInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ManagedDashboardImpl((ManagedDashboardInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ManagedDashboard> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<ManagedDashboardInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ManagedDashboardImpl((ManagedDashboardInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ManagedDashboard> list() {
        PagedIterable<ManagedDashboardInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ManagedDashboardImpl((ManagedDashboardInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ManagedDashboard> list(Context context) {
        PagedIterable<ManagedDashboardInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ManagedDashboardImpl((ManagedDashboardInner)((Object)inner1), this.manager()));
    }

    @Override
    public ManagedDashboard getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dashboardName = ResourceManagerUtils.getValueFromIdByName(id, "dashboards");
        if (dashboardName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dashboards'.", id)));
        }
        return (ManagedDashboard)this.getByResourceGroupWithResponse(resourceGroupName, dashboardName, Context.NONE).getValue();
    }

    @Override
    public Response<ManagedDashboard> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dashboardName = ResourceManagerUtils.getValueFromIdByName(id, "dashboards");
        if (dashboardName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dashboards'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, dashboardName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dashboardName = ResourceManagerUtils.getValueFromIdByName(id, "dashboards");
        if (dashboardName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dashboards'.", id)));
        }
        this.deleteByResourceGroupWithResponse(resourceGroupName, dashboardName, Context.NONE);
    }

    @Override
    public Response<Void> deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String dashboardName = ResourceManagerUtils.getValueFromIdByName(id, "dashboards");
        if (dashboardName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'dashboards'.", id)));
        }
        return this.deleteByResourceGroupWithResponse(resourceGroupName, dashboardName, context);
    }

    private ManagedDashboardsClient serviceClient() {
        return this.innerClient;
    }

    private DashboardManager manager() {
        return this.serviceManager;
    }

    @Override
    public ManagedDashboardImpl define(String name) {
        return new ManagedDashboardImpl(name, this.manager());
    }
}

