/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dashboard.fluent.models.ManagedDashboardProperties;
import com.azure.resourcemanager.dashboard.models.ProvisioningState;
import java.io.IOException;
import java.util.Map;

public final class ManagedDashboardInner
extends Resource {
    private ManagedDashboardProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private ManagedDashboardProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ManagedDashboardInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ManagedDashboardInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ManagedDashboardInner fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedDashboardInner)((Object)jsonReader.readObject(reader -> {
            ManagedDashboardInner deserializedManagedDashboardInner = new ManagedDashboardInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedManagedDashboardInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedManagedDashboardInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedManagedDashboardInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedManagedDashboardInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedManagedDashboardInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedManagedDashboardInner.innerProperties = ManagedDashboardProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedManagedDashboardInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedDashboardInner;
        }));
    }
}

