/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dashboard.models.IntegrationFabricProperties;
import java.io.IOException;
import java.util.Map;

public final class IntegrationFabricInner
extends Resource {
    private IntegrationFabricProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public IntegrationFabricProperties properties() {
        return this.properties;
    }

    public IntegrationFabricInner withProperties(IntegrationFabricProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public IntegrationFabricInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public IntegrationFabricInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static IntegrationFabricInner fromJson(JsonReader jsonReader) throws IOException {
        return (IntegrationFabricInner)((Object)jsonReader.readObject(reader -> {
            IntegrationFabricInner deserializedIntegrationFabricInner = new IntegrationFabricInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedIntegrationFabricInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedIntegrationFabricInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIntegrationFabricInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedIntegrationFabricInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedIntegrationFabricInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedIntegrationFabricInner.properties = IntegrationFabricProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedIntegrationFabricInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIntegrationFabricInner;
        }));
    }
}

