/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dashboard.fluent.models.ManagedPrivateEndpointModelInner;
import com.azure.resourcemanager.dashboard.models.ManagedPrivateEndpointConnectionState;
import com.azure.resourcemanager.dashboard.models.ProvisioningState;
import java.util.List;
import java.util.Map;

public interface ManagedPrivateEndpointModel {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public SystemData systemData();

    public ProvisioningState provisioningState();

    public String privateLinkResourceId();

    public String privateLinkResourceRegion();

    public List<String> groupIds();

    public String requestMessage();

    public ManagedPrivateEndpointConnectionState connectionState();

    public String privateLinkServiceUrl();

    public String privateLinkServicePrivateIp();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ManagedPrivateEndpointModelInner innerModel();

    public Update update();

    public ManagedPrivateEndpointModel refresh();

    public ManagedPrivateEndpointModel refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags {
        public ManagedPrivateEndpointModel apply();

        public ManagedPrivateEndpointModel apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithPrivateLinkServiceUrl {
            public WithCreate withPrivateLinkServiceUrl(String var1);
        }

        public static interface WithRequestMessage {
            public WithCreate withRequestMessage(String var1);
        }

        public static interface WithGroupIds {
            public WithCreate withGroupIds(List<String> var1);
        }

        public static interface WithPrivateLinkResourceRegion {
            public WithCreate withPrivateLinkResourceRegion(String var1);
        }

        public static interface WithPrivateLinkResourceId {
            public WithCreate withPrivateLinkResourceId(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithPrivateLinkResourceId,
        WithPrivateLinkResourceRegion,
        WithGroupIds,
        WithRequestMessage,
        WithPrivateLinkServiceUrl {
            public ManagedPrivateEndpointModel create();

            public ManagedPrivateEndpointModel create(Context var1);
        }

        public static interface WithParentResource {
            public WithCreate withExistingGrafana(String var1, String var2);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithCreate {
    }
}

