/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.dashboard.fluent.models.ManagedDashboardInner;
import java.io.IOException;
import java.util.List;

public final class ManagedDashboardListResponse
implements JsonSerializable<ManagedDashboardListResponse> {
    private List<ManagedDashboardInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ManagedDashboardListResponse.class);

    private ManagedDashboardListResponse() {
    }

    public List<ManagedDashboardInner> value() {
        return this.value;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ManagedDashboardListResponse"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ManagedDashboardListResponse fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedDashboardListResponse)jsonReader.readObject(reader -> {
            ManagedDashboardListResponse deserializedManagedDashboardListResponse = new ManagedDashboardListResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedManagedDashboardListResponse.value = value = reader.readArray(reader1 -> ManagedDashboardInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedManagedDashboardListResponse.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedDashboardListResponse;
        });
    }
}

