/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.dashboard.DashboardManager;
import com.azure.resourcemanager.dashboard.fluent.ManagedPrivateEndpointsClient;
import com.azure.resourcemanager.dashboard.fluent.models.ManagedPrivateEndpointModelInner;
import com.azure.resourcemanager.dashboard.implementation.ManagedPrivateEndpointModelImpl;
import com.azure.resourcemanager.dashboard.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dashboard.models.ManagedPrivateEndpointModel;
import com.azure.resourcemanager.dashboard.models.ManagedPrivateEndpoints;

public final class ManagedPrivateEndpointsImpl
implements ManagedPrivateEndpoints {
    private static final ClientLogger LOGGER = new ClientLogger(ManagedPrivateEndpointsImpl.class);
    private final ManagedPrivateEndpointsClient innerClient;
    private final DashboardManager serviceManager;

    public ManagedPrivateEndpointsImpl(ManagedPrivateEndpointsClient innerClient, DashboardManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public void refresh(String resourceGroupName, String workspaceName) {
        this.serviceClient().refresh(resourceGroupName, workspaceName);
    }

    @Override
    public void refresh(String resourceGroupName, String workspaceName, Context context) {
        this.serviceClient().refresh(resourceGroupName, workspaceName, context);
    }

    @Override
    public Response<ManagedPrivateEndpointModel> getWithResponse(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, Context context) {
        Response<ManagedPrivateEndpointModelInner> inner = this.serviceClient().getWithResponse(resourceGroupName, workspaceName, managedPrivateEndpointName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ManagedPrivateEndpointModelImpl((ManagedPrivateEndpointModelInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ManagedPrivateEndpointModel get(String resourceGroupName, String workspaceName, String managedPrivateEndpointName) {
        ManagedPrivateEndpointModelInner inner = this.serviceClient().get(resourceGroupName, workspaceName, managedPrivateEndpointName);
        if (inner != null) {
            return new ManagedPrivateEndpointModelImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public void delete(String resourceGroupName, String workspaceName, String managedPrivateEndpointName) {
        this.serviceClient().delete(resourceGroupName, workspaceName, managedPrivateEndpointName);
    }

    @Override
    public void delete(String resourceGroupName, String workspaceName, String managedPrivateEndpointName, Context context) {
        this.serviceClient().delete(resourceGroupName, workspaceName, managedPrivateEndpointName, context);
    }

    @Override
    public PagedIterable<ManagedPrivateEndpointModel> list(String resourceGroupName, String workspaceName) {
        PagedIterable<ManagedPrivateEndpointModelInner> inner = this.serviceClient().list(resourceGroupName, workspaceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ManagedPrivateEndpointModelImpl((ManagedPrivateEndpointModelInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ManagedPrivateEndpointModel> list(String resourceGroupName, String workspaceName, Context context) {
        PagedIterable<ManagedPrivateEndpointModelInner> inner = this.serviceClient().list(resourceGroupName, workspaceName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ManagedPrivateEndpointModelImpl((ManagedPrivateEndpointModelInner)((Object)inner1), this.manager()));
    }

    @Override
    public ManagedPrivateEndpointModel getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "grafana");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'grafana'.", id)));
        }
        String managedPrivateEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "managedPrivateEndpoints");
        if (managedPrivateEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedPrivateEndpoints'.", id)));
        }
        return (ManagedPrivateEndpointModel)this.getWithResponse(resourceGroupName, workspaceName, managedPrivateEndpointName, Context.NONE).getValue();
    }

    @Override
    public Response<ManagedPrivateEndpointModel> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "grafana");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'grafana'.", id)));
        }
        String managedPrivateEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "managedPrivateEndpoints");
        if (managedPrivateEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedPrivateEndpoints'.", id)));
        }
        return this.getWithResponse(resourceGroupName, workspaceName, managedPrivateEndpointName, context);
    }

    @Override
    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "grafana");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'grafana'.", id)));
        }
        String managedPrivateEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "managedPrivateEndpoints");
        if (managedPrivateEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedPrivateEndpoints'.", id)));
        }
        this.delete(resourceGroupName, workspaceName, managedPrivateEndpointName, Context.NONE);
    }

    @Override
    public void deleteByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String workspaceName = ResourceManagerUtils.getValueFromIdByName(id, "grafana");
        if (workspaceName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'grafana'.", id)));
        }
        String managedPrivateEndpointName = ResourceManagerUtils.getValueFromIdByName(id, "managedPrivateEndpoints");
        if (managedPrivateEndpointName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'managedPrivateEndpoints'.", id)));
        }
        this.delete(resourceGroupName, workspaceName, managedPrivateEndpointName, context);
    }

    private ManagedPrivateEndpointsClient serviceClient() {
        return this.innerClient;
    }

    private DashboardManager manager() {
        return this.serviceManager;
    }

    @Override
    public ManagedPrivateEndpointModelImpl define(String name) {
        return new ManagedPrivateEndpointModelImpl(name, this.manager());
    }
}

