/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dashboard.DashboardManager;
import com.azure.resourcemanager.dashboard.fluent.models.ManagedGrafanaInner;
import com.azure.resourcemanager.dashboard.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dashboard.models.EnterpriseDetails;
import com.azure.resourcemanager.dashboard.models.GrafanaAvailablePluginListResponse;
import com.azure.resourcemanager.dashboard.models.ManagedGrafana;
import com.azure.resourcemanager.dashboard.models.ManagedGrafanaProperties;
import com.azure.resourcemanager.dashboard.models.ManagedGrafanaPropertiesUpdateParameters;
import com.azure.resourcemanager.dashboard.models.ManagedGrafanaUpdateParameters;
import com.azure.resourcemanager.dashboard.models.ManagedServiceIdentity;
import com.azure.resourcemanager.dashboard.models.ResourceSku;
import java.util.Collections;
import java.util.Map;

public final class ManagedGrafanaImpl
implements ManagedGrafana,
ManagedGrafana.Definition,
ManagedGrafana.Update {
    private ManagedGrafanaInner innerObject;
    private final DashboardManager serviceManager;
    private String resourceGroupName;
    private String workspaceName;
    private ManagedGrafanaUpdateParameters updateRequestBodyParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public ManagedGrafanaProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public ResourceSku sku() {
        return this.innerModel().sku();
    }

    @Override
    public Map<String, String> tags() {
        Map<String, String> inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public ManagedServiceIdentity identity() {
        return this.innerModel().identity();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public ManagedGrafanaInner innerModel() {
        return this.innerObject;
    }

    private DashboardManager manager() {
        return this.serviceManager;
    }

    @Override
    public ManagedGrafanaImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public ManagedGrafana create() {
        this.innerObject = this.serviceManager.serviceClient().getGrafanas().create(this.resourceGroupName, this.workspaceName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public ManagedGrafana create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGrafanas().create(this.resourceGroupName, this.workspaceName, this.innerModel(), context);
        return this;
    }

    ManagedGrafanaImpl(String name, DashboardManager serviceManager) {
        this.innerObject = new ManagedGrafanaInner();
        this.serviceManager = serviceManager;
        this.workspaceName = name;
    }

    @Override
    public ManagedGrafanaImpl update() {
        this.updateRequestBodyParameters = new ManagedGrafanaUpdateParameters();
        return this;
    }

    @Override
    public ManagedGrafana apply() {
        this.innerObject = this.serviceManager.serviceClient().getGrafanas().update(this.resourceGroupName, this.workspaceName, this.updateRequestBodyParameters, Context.NONE);
        return this;
    }

    @Override
    public ManagedGrafana apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getGrafanas().update(this.resourceGroupName, this.workspaceName, this.updateRequestBodyParameters, context);
        return this;
    }

    ManagedGrafanaImpl(ManagedGrafanaInner innerObject, DashboardManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.workspaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "grafana");
    }

    @Override
    public ManagedGrafana refresh() {
        this.innerObject = (ManagedGrafanaInner)((Object)this.serviceManager.serviceClient().getGrafanas().getByResourceGroupWithResponse(this.resourceGroupName, this.workspaceName, Context.NONE).getValue());
        return this;
    }

    @Override
    public ManagedGrafana refresh(Context context) {
        this.innerObject = (ManagedGrafanaInner)((Object)this.serviceManager.serviceClient().getGrafanas().getByResourceGroupWithResponse(this.resourceGroupName, this.workspaceName, context).getValue());
        return this;
    }

    @Override
    public Response<EnterpriseDetails> checkEnterpriseDetailsWithResponse(Context context) {
        return this.serviceManager.grafanas().checkEnterpriseDetailsWithResponse(this.resourceGroupName, this.workspaceName, context);
    }

    @Override
    public EnterpriseDetails checkEnterpriseDetails() {
        return this.serviceManager.grafanas().checkEnterpriseDetails(this.resourceGroupName, this.workspaceName);
    }

    @Override
    public Response<GrafanaAvailablePluginListResponse> fetchAvailablePluginsWithResponse(Context context) {
        return this.serviceManager.grafanas().fetchAvailablePluginsWithResponse(this.resourceGroupName, this.workspaceName, context);
    }

    @Override
    public GrafanaAvailablePluginListResponse fetchAvailablePlugins() {
        return this.serviceManager.grafanas().fetchAvailablePlugins(this.resourceGroupName, this.workspaceName);
    }

    @Override
    public ManagedGrafanaImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public ManagedGrafanaImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public ManagedGrafanaImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags(tags);
            return this;
        }
        this.updateRequestBodyParameters.withTags(tags);
        return this;
    }

    @Override
    public ManagedGrafanaImpl withProperties(ManagedGrafanaProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public ManagedGrafanaImpl withSku(ResourceSku sku) {
        if (this.isInCreateMode()) {
            this.innerModel().withSku(sku);
            return this;
        }
        this.updateRequestBodyParameters.withSku(sku);
        return this;
    }

    @Override
    public ManagedGrafanaImpl withIdentity(ManagedServiceIdentity identity) {
        if (this.isInCreateMode()) {
            this.innerModel().withIdentity(identity);
            return this;
        }
        this.updateRequestBodyParameters.withIdentity(identity);
        return this;
    }

    @Override
    public ManagedGrafanaImpl withProperties(ManagedGrafanaPropertiesUpdateParameters properties) {
        this.updateRequestBodyParameters.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

