/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.dashboard.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.dashboard.DashboardManager;
import com.azure.resourcemanager.dashboard.fluent.models.IntegrationFabricInner;
import com.azure.resourcemanager.dashboard.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.dashboard.models.IntegrationFabric;
import com.azure.resourcemanager.dashboard.models.IntegrationFabricProperties;
import com.azure.resourcemanager.dashboard.models.IntegrationFabricPropertiesUpdateParameters;
import com.azure.resourcemanager.dashboard.models.IntegrationFabricUpdateParameters;
import java.util.Collections;
import java.util.Map;

public final class IntegrationFabricImpl
implements IntegrationFabric,
IntegrationFabric.Definition,
IntegrationFabric.Update {
    private IntegrationFabricInner innerObject;
    private final DashboardManager serviceManager;
    private String resourceGroupName;
    private String workspaceName;
    private String integrationFabricName;
    private IntegrationFabricUpdateParameters updateRequestBodyParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public IntegrationFabricProperties properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public IntegrationFabricInner innerModel() {
        return this.innerObject;
    }

    private DashboardManager manager() {
        return this.serviceManager;
    }

    @Override
    public IntegrationFabricImpl withExistingGrafana(String resourceGroupName, String workspaceName) {
        this.resourceGroupName = resourceGroupName;
        this.workspaceName = workspaceName;
        return this;
    }

    @Override
    public IntegrationFabric create() {
        this.innerObject = this.serviceManager.serviceClient().getIntegrationFabrics().create(this.resourceGroupName, this.workspaceName, this.integrationFabricName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public IntegrationFabric create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getIntegrationFabrics().create(this.resourceGroupName, this.workspaceName, this.integrationFabricName, this.innerModel(), context);
        return this;
    }

    IntegrationFabricImpl(String name, DashboardManager serviceManager) {
        this.innerObject = new IntegrationFabricInner();
        this.serviceManager = serviceManager;
        this.integrationFabricName = name;
    }

    @Override
    public IntegrationFabricImpl update() {
        this.updateRequestBodyParameters = new IntegrationFabricUpdateParameters();
        return this;
    }

    @Override
    public IntegrationFabric apply() {
        this.innerObject = this.serviceManager.serviceClient().getIntegrationFabrics().update(this.resourceGroupName, this.workspaceName, this.integrationFabricName, this.updateRequestBodyParameters, Context.NONE);
        return this;
    }

    @Override
    public IntegrationFabric apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getIntegrationFabrics().update(this.resourceGroupName, this.workspaceName, this.integrationFabricName, this.updateRequestBodyParameters, context);
        return this;
    }

    IntegrationFabricImpl(IntegrationFabricInner innerObject, DashboardManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.workspaceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "grafana");
        this.integrationFabricName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "integrationFabrics");
    }

    @Override
    public IntegrationFabric refresh() {
        this.innerObject = (IntegrationFabricInner)((Object)this.serviceManager.serviceClient().getIntegrationFabrics().getWithResponse(this.resourceGroupName, this.workspaceName, this.integrationFabricName, Context.NONE).getValue());
        return this;
    }

    @Override
    public IntegrationFabric refresh(Context context) {
        this.innerObject = (IntegrationFabricInner)((Object)this.serviceManager.serviceClient().getIntegrationFabrics().getWithResponse(this.resourceGroupName, this.workspaceName, this.integrationFabricName, context).getValue());
        return this;
    }

    @Override
    public IntegrationFabricImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public IntegrationFabricImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public IntegrationFabricImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateRequestBodyParameters.withTags(tags);
        return this;
    }

    @Override
    public IntegrationFabricImpl withProperties(IntegrationFabricProperties properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public IntegrationFabricImpl withProperties(IntegrationFabricPropertiesUpdateParameters properties) {
        this.updateRequestBodyParameters.withProperties(properties);
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

