/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerservice.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerservice.models.ManagedClusterPodIdentity;
import com.azure.resourcemanager.containerservice.models.ManagedClusterPodIdentityException;
import java.io.IOException;
import java.util.List;

public final class ManagedClusterPodIdentityProfile
implements JsonSerializable<ManagedClusterPodIdentityProfile> {
    private Boolean enabled;
    private Boolean allowNetworkPluginKubenet;
    private List<ManagedClusterPodIdentity> userAssignedIdentities;
    private List<ManagedClusterPodIdentityException> userAssignedIdentityExceptions;

    public Boolean enabled() {
        return this.enabled;
    }

    public ManagedClusterPodIdentityProfile withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean allowNetworkPluginKubenet() {
        return this.allowNetworkPluginKubenet;
    }

    public ManagedClusterPodIdentityProfile withAllowNetworkPluginKubenet(Boolean allowNetworkPluginKubenet) {
        this.allowNetworkPluginKubenet = allowNetworkPluginKubenet;
        return this;
    }

    public List<ManagedClusterPodIdentity> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    public ManagedClusterPodIdentityProfile withUserAssignedIdentities(List<ManagedClusterPodIdentity> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    public List<ManagedClusterPodIdentityException> userAssignedIdentityExceptions() {
        return this.userAssignedIdentityExceptions;
    }

    public ManagedClusterPodIdentityProfile withUserAssignedIdentityExceptions(List<ManagedClusterPodIdentityException> userAssignedIdentityExceptions) {
        this.userAssignedIdentityExceptions = userAssignedIdentityExceptions;
        return this;
    }

    public void validate() {
        if (this.userAssignedIdentities() != null) {
            this.userAssignedIdentities().forEach(e -> e.validate());
        }
        if (this.userAssignedIdentityExceptions() != null) {
            this.userAssignedIdentityExceptions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("enabled", this.enabled);
        jsonWriter.writeBooleanField("allowNetworkPluginKubenet", this.allowNetworkPluginKubenet);
        jsonWriter.writeArrayField("userAssignedIdentities", this.userAssignedIdentities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userAssignedIdentityExceptions", this.userAssignedIdentityExceptions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ManagedClusterPodIdentityProfile fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedClusterPodIdentityProfile)jsonReader.readObject(reader -> {
            ManagedClusterPodIdentityProfile deserializedManagedClusterPodIdentityProfile = new ManagedClusterPodIdentityProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("enabled".equals(fieldName)) {
                    deserializedManagedClusterPodIdentityProfile.enabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("allowNetworkPluginKubenet".equals(fieldName)) {
                    deserializedManagedClusterPodIdentityProfile.allowNetworkPluginKubenet = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("userAssignedIdentities".equals(fieldName)) {
                    List userAssignedIdentities;
                    deserializedManagedClusterPodIdentityProfile.userAssignedIdentities = userAssignedIdentities = reader.readArray(reader1 -> ManagedClusterPodIdentity.fromJson(reader1));
                    continue;
                }
                if ("userAssignedIdentityExceptions".equals(fieldName)) {
                    List userAssignedIdentityExceptions;
                    deserializedManagedClusterPodIdentityProfile.userAssignedIdentityExceptions = userAssignedIdentityExceptions = reader.readArray(reader1 -> ManagedClusterPodIdentityException.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagedClusterPodIdentityProfile;
        });
    }
}

