/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class KeyVaultProperties
implements JsonSerializable<KeyVaultProperties> {
    private String keyIdentifier;
    private String versionedKeyIdentifier;
    private String identity;
    private Boolean keyRotationEnabled;
    private OffsetDateTime lastKeyRotationTimestamp;

    public String keyIdentifier() {
        return this.keyIdentifier;
    }

    public KeyVaultProperties withKeyIdentifier(String keyIdentifier) {
        this.keyIdentifier = keyIdentifier;
        return this;
    }

    public String versionedKeyIdentifier() {
        return this.versionedKeyIdentifier;
    }

    public String identity() {
        return this.identity;
    }

    public KeyVaultProperties withIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public Boolean keyRotationEnabled() {
        return this.keyRotationEnabled;
    }

    public OffsetDateTime lastKeyRotationTimestamp() {
        return this.lastKeyRotationTimestamp;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyIdentifier", this.keyIdentifier);
        jsonWriter.writeStringField("identity", this.identity);
        return jsonWriter.writeEndObject();
    }

    public static KeyVaultProperties fromJson(JsonReader jsonReader) throws IOException {
        return (KeyVaultProperties)jsonReader.readObject(reader -> {
            KeyVaultProperties deserializedKeyVaultProperties = new KeyVaultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("keyIdentifier".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyIdentifier = reader.getString();
                    continue;
                }
                if ("versionedKeyIdentifier".equals(fieldName)) {
                    deserializedKeyVaultProperties.versionedKeyIdentifier = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedKeyVaultProperties.identity = reader.getString();
                    continue;
                }
                if ("keyRotationEnabled".equals(fieldName)) {
                    deserializedKeyVaultProperties.keyRotationEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("lastKeyRotationTimestamp".equals(fieldName)) {
                    deserializedKeyVaultProperties.lastKeyRotationTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyVaultProperties;
        });
    }
}

