/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerregistry.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerregistry.models.AgentProperties;
import com.azure.resourcemanager.containerregistry.models.ImageDescriptor;
import com.azure.resourcemanager.containerregistry.models.ImageUpdateTrigger;
import com.azure.resourcemanager.containerregistry.models.PlatformProperties;
import com.azure.resourcemanager.containerregistry.models.ProvisioningState;
import com.azure.resourcemanager.containerregistry.models.RunStatus;
import com.azure.resourcemanager.containerregistry.models.RunType;
import com.azure.resourcemanager.containerregistry.models.SourceTriggerDescriptor;
import com.azure.resourcemanager.containerregistry.models.TimerTriggerDescriptor;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class RunProperties
implements JsonSerializable<RunProperties> {
    private String runId;
    private RunStatus status;
    private OffsetDateTime lastUpdatedTime;
    private RunType runType;
    private String agentPoolName;
    private OffsetDateTime createTime;
    private OffsetDateTime startTime;
    private OffsetDateTime finishTime;
    private List<ImageDescriptor> outputImages;
    private String task;
    private ImageUpdateTrigger imageUpdateTrigger;
    private SourceTriggerDescriptor sourceTrigger;
    private TimerTriggerDescriptor timerTrigger;
    private PlatformProperties platform;
    private AgentProperties agentConfiguration;
    private String sourceRegistryAuth;
    private List<String> customRegistries;
    private String runErrorMessage;
    private String updateTriggerToken;
    private ImageDescriptor logArtifact;
    private ProvisioningState provisioningState;
    private Boolean isArchiveEnabled;

    public String runId() {
        return this.runId;
    }

    public RunProperties withRunId(String runId) {
        this.runId = runId;
        return this;
    }

    public RunStatus status() {
        return this.status;
    }

    public RunProperties withStatus(RunStatus status) {
        this.status = status;
        return this;
    }

    public OffsetDateTime lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public RunProperties withLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
        return this;
    }

    public RunType runType() {
        return this.runType;
    }

    public RunProperties withRunType(RunType runType) {
        this.runType = runType;
        return this;
    }

    public String agentPoolName() {
        return this.agentPoolName;
    }

    public RunProperties withAgentPoolName(String agentPoolName) {
        this.agentPoolName = agentPoolName;
        return this;
    }

    public OffsetDateTime createTime() {
        return this.createTime;
    }

    public RunProperties withCreateTime(OffsetDateTime createTime) {
        this.createTime = createTime;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public RunProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime finishTime() {
        return this.finishTime;
    }

    public RunProperties withFinishTime(OffsetDateTime finishTime) {
        this.finishTime = finishTime;
        return this;
    }

    public List<ImageDescriptor> outputImages() {
        return this.outputImages;
    }

    public RunProperties withOutputImages(List<ImageDescriptor> outputImages) {
        this.outputImages = outputImages;
        return this;
    }

    public String task() {
        return this.task;
    }

    public RunProperties withTask(String task) {
        this.task = task;
        return this;
    }

    public ImageUpdateTrigger imageUpdateTrigger() {
        return this.imageUpdateTrigger;
    }

    public RunProperties withImageUpdateTrigger(ImageUpdateTrigger imageUpdateTrigger) {
        this.imageUpdateTrigger = imageUpdateTrigger;
        return this;
    }

    public SourceTriggerDescriptor sourceTrigger() {
        return this.sourceTrigger;
    }

    public RunProperties withSourceTrigger(SourceTriggerDescriptor sourceTrigger) {
        this.sourceTrigger = sourceTrigger;
        return this;
    }

    public TimerTriggerDescriptor timerTrigger() {
        return this.timerTrigger;
    }

    public RunProperties withTimerTrigger(TimerTriggerDescriptor timerTrigger) {
        this.timerTrigger = timerTrigger;
        return this;
    }

    public PlatformProperties platform() {
        return this.platform;
    }

    public RunProperties withPlatform(PlatformProperties platform) {
        this.platform = platform;
        return this;
    }

    public AgentProperties agentConfiguration() {
        return this.agentConfiguration;
    }

    public RunProperties withAgentConfiguration(AgentProperties agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        return this;
    }

    public String sourceRegistryAuth() {
        return this.sourceRegistryAuth;
    }

    public RunProperties withSourceRegistryAuth(String sourceRegistryAuth) {
        this.sourceRegistryAuth = sourceRegistryAuth;
        return this;
    }

    public List<String> customRegistries() {
        return this.customRegistries;
    }

    public RunProperties withCustomRegistries(List<String> customRegistries) {
        this.customRegistries = customRegistries;
        return this;
    }

    public String runErrorMessage() {
        return this.runErrorMessage;
    }

    public String updateTriggerToken() {
        return this.updateTriggerToken;
    }

    public RunProperties withUpdateTriggerToken(String updateTriggerToken) {
        this.updateTriggerToken = updateTriggerToken;
        return this;
    }

    public ImageDescriptor logArtifact() {
        return this.logArtifact;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public RunProperties withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public Boolean isArchiveEnabled() {
        return this.isArchiveEnabled;
    }

    public RunProperties withIsArchiveEnabled(Boolean isArchiveEnabled) {
        this.isArchiveEnabled = isArchiveEnabled;
        return this;
    }

    public void validate() {
        if (this.outputImages() != null) {
            this.outputImages().forEach(e -> e.validate());
        }
        if (this.imageUpdateTrigger() != null) {
            this.imageUpdateTrigger().validate();
        }
        if (this.sourceTrigger() != null) {
            this.sourceTrigger().validate();
        }
        if (this.timerTrigger() != null) {
            this.timerTrigger().validate();
        }
        if (this.platform() != null) {
            this.platform().validate();
        }
        if (this.agentConfiguration() != null) {
            this.agentConfiguration().validate();
        }
        if (this.logArtifact() != null) {
            this.logArtifact().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("runId", this.runId);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("lastUpdatedTime", this.lastUpdatedTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedTime));
        jsonWriter.writeStringField("runType", this.runType == null ? null : this.runType.toString());
        jsonWriter.writeStringField("agentPoolName", this.agentPoolName);
        jsonWriter.writeStringField("createTime", this.createTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createTime));
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("finishTime", this.finishTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.finishTime));
        jsonWriter.writeArrayField("outputImages", this.outputImages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("task", this.task);
        jsonWriter.writeJsonField("imageUpdateTrigger", (JsonSerializable)this.imageUpdateTrigger);
        jsonWriter.writeJsonField("sourceTrigger", (JsonSerializable)this.sourceTrigger);
        jsonWriter.writeJsonField("timerTrigger", (JsonSerializable)this.timerTrigger);
        jsonWriter.writeJsonField("platform", (JsonSerializable)this.platform);
        jsonWriter.writeJsonField("agentConfiguration", (JsonSerializable)this.agentConfiguration);
        jsonWriter.writeStringField("sourceRegistryAuth", this.sourceRegistryAuth);
        jsonWriter.writeArrayField("customRegistries", this.customRegistries, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("updateTriggerToken", this.updateTriggerToken);
        jsonWriter.writeStringField("provisioningState", this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeBooleanField("isArchiveEnabled", this.isArchiveEnabled);
        return jsonWriter.writeEndObject();
    }

    public static RunProperties fromJson(JsonReader jsonReader) throws IOException {
        return (RunProperties)jsonReader.readObject(reader -> {
            RunProperties deserializedRunProperties = new RunProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("runId".equals(fieldName)) {
                    deserializedRunProperties.runId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedRunProperties.status = RunStatus.fromString(reader.getString());
                    continue;
                }
                if ("lastUpdatedTime".equals(fieldName)) {
                    deserializedRunProperties.lastUpdatedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("runType".equals(fieldName)) {
                    deserializedRunProperties.runType = RunType.fromString(reader.getString());
                    continue;
                }
                if ("agentPoolName".equals(fieldName)) {
                    deserializedRunProperties.agentPoolName = reader.getString();
                    continue;
                }
                if ("createTime".equals(fieldName)) {
                    deserializedRunProperties.createTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedRunProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("finishTime".equals(fieldName)) {
                    deserializedRunProperties.finishTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("outputImages".equals(fieldName)) {
                    List outputImages;
                    deserializedRunProperties.outputImages = outputImages = reader.readArray(reader1 -> ImageDescriptor.fromJson(reader1));
                    continue;
                }
                if ("task".equals(fieldName)) {
                    deserializedRunProperties.task = reader.getString();
                    continue;
                }
                if ("imageUpdateTrigger".equals(fieldName)) {
                    deserializedRunProperties.imageUpdateTrigger = ImageUpdateTrigger.fromJson(reader);
                    continue;
                }
                if ("sourceTrigger".equals(fieldName)) {
                    deserializedRunProperties.sourceTrigger = SourceTriggerDescriptor.fromJson(reader);
                    continue;
                }
                if ("timerTrigger".equals(fieldName)) {
                    deserializedRunProperties.timerTrigger = TimerTriggerDescriptor.fromJson(reader);
                    continue;
                }
                if ("platform".equals(fieldName)) {
                    deserializedRunProperties.platform = PlatformProperties.fromJson(reader);
                    continue;
                }
                if ("agentConfiguration".equals(fieldName)) {
                    deserializedRunProperties.agentConfiguration = AgentProperties.fromJson(reader);
                    continue;
                }
                if ("sourceRegistryAuth".equals(fieldName)) {
                    deserializedRunProperties.sourceRegistryAuth = reader.getString();
                    continue;
                }
                if ("customRegistries".equals(fieldName)) {
                    List customRegistries;
                    deserializedRunProperties.customRegistries = customRegistries = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("runErrorMessage".equals(fieldName)) {
                    deserializedRunProperties.runErrorMessage = reader.getString();
                    continue;
                }
                if ("updateTriggerToken".equals(fieldName)) {
                    deserializedRunProperties.updateTriggerToken = reader.getString();
                    continue;
                }
                if ("logArtifact".equals(fieldName)) {
                    deserializedRunProperties.logArtifact = ImageDescriptor.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRunProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("isArchiveEnabled".equals(fieldName)) {
                    deserializedRunProperties.isArchiveEnabled = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRunProperties;
        });
    }
}

