/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerinstance.models.CapabilitiesCapabilities;
import java.io.IOException;

public final class Capabilities
implements JsonSerializable<Capabilities> {
    private String resourceType;
    private String osType;
    private String location;
    private String ipAddressType;
    private String gpu;
    private CapabilitiesCapabilities capabilities;

    public String resourceType() {
        return this.resourceType;
    }

    public String osType() {
        return this.osType;
    }

    public String location() {
        return this.location;
    }

    public String ipAddressType() {
        return this.ipAddressType;
    }

    public String gpu() {
        return this.gpu;
    }

    public CapabilitiesCapabilities capabilities() {
        return this.capabilities;
    }

    public void validate() {
        if (this.capabilities() != null) {
            this.capabilities().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static Capabilities fromJson(JsonReader jsonReader) throws IOException {
        return (Capabilities)jsonReader.readObject(reader -> {
            Capabilities deserializedCapabilities = new Capabilities();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceType".equals(fieldName)) {
                    deserializedCapabilities.resourceType = reader.getString();
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    deserializedCapabilities.osType = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedCapabilities.location = reader.getString();
                    continue;
                }
                if ("ipAddressType".equals(fieldName)) {
                    deserializedCapabilities.ipAddressType = reader.getString();
                    continue;
                }
                if ("gpu".equals(fieldName)) {
                    deserializedCapabilities.gpu = reader.getString();
                    continue;
                }
                if ("capabilities".equals(fieldName)) {
                    deserializedCapabilities.capabilities = CapabilitiesCapabilities.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCapabilities;
        });
    }
}

