/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupIpAddressType;
import com.azure.resourcemanager.containerinstance.models.Port;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class IpAddress {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(IpAddress.class);
    @JsonProperty(value="ports", required=true)
    private List<Port> ports;
    @JsonProperty(value="type", required=true)
    private ContainerGroupIpAddressType type;
    @JsonProperty(value="ip")
    private String ip;
    @JsonProperty(value="dnsNameLabel")
    private String dnsNameLabel;
    @JsonProperty(value="fqdn", access=JsonProperty.Access.WRITE_ONLY)
    private String fqdn;

    public List<Port> ports() {
        return this.ports;
    }

    public IpAddress withPorts(List<Port> ports) {
        this.ports = ports;
        return this;
    }

    public ContainerGroupIpAddressType type() {
        return this.type;
    }

    public IpAddress withType(ContainerGroupIpAddressType type) {
        this.type = type;
        return this;
    }

    public String ip() {
        return this.ip;
    }

    public IpAddress withIp(String ip) {
        this.ip = ip;
        return this;
    }

    public String dnsNameLabel() {
        return this.dnsNameLabel;
    }

    public IpAddress withDnsNameLabel(String dnsNameLabel) {
        this.dnsNameLabel = dnsNameLabel;
        return this;
    }

    public String fqdn() {
        return this.fqdn;
    }

    public void validate() {
        if (this.ports() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property ports in model IpAddress"));
        }
        this.ports().forEach(e -> e.validate());
        if (this.type() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property type in model IpAddress"));
        }
    }
}

