/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.GalleryInVMAccessControlProfileVersionProperties;
import com.azure.resourcemanager.compute.models.AccessControlRules;
import com.azure.resourcemanager.compute.models.AccessControlRulesMode;
import com.azure.resourcemanager.compute.models.EndpointAccess;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.ReplicationStatus;
import com.azure.resourcemanager.compute.models.TargetRegion;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class GalleryInVMAccessControlProfileVersionInner
extends Resource {
    private GalleryInVMAccessControlProfileVersionProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private GalleryInVMAccessControlProfileVersionProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public GalleryInVMAccessControlProfileVersionInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public GalleryInVMAccessControlProfileVersionInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public AccessControlRulesMode mode() {
        return this.innerProperties() == null ? null : this.innerProperties().mode();
    }

    public GalleryInVMAccessControlProfileVersionInner withMode(AccessControlRulesMode mode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryInVMAccessControlProfileVersionProperties();
        }
        this.innerProperties().withMode(mode);
        return this;
    }

    public EndpointAccess defaultAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultAccess();
    }

    public GalleryInVMAccessControlProfileVersionInner withDefaultAccess(EndpointAccess defaultAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryInVMAccessControlProfileVersionProperties();
        }
        this.innerProperties().withDefaultAccess(defaultAccess);
        return this;
    }

    public AccessControlRules rules() {
        return this.innerProperties() == null ? null : this.innerProperties().rules();
    }

    public GalleryInVMAccessControlProfileVersionInner withRules(AccessControlRules rules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryInVMAccessControlProfileVersionProperties();
        }
        this.innerProperties().withRules(rules);
        return this;
    }

    public List<TargetRegion> targetLocations() {
        return this.innerProperties() == null ? null : this.innerProperties().targetLocations();
    }

    public GalleryInVMAccessControlProfileVersionInner withTargetLocations(List<TargetRegion> targetLocations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryInVMAccessControlProfileVersionProperties();
        }
        this.innerProperties().withTargetLocations((List)targetLocations);
        return this;
    }

    public Boolean excludeFromLatest() {
        return this.innerProperties() == null ? null : this.innerProperties().excludeFromLatest();
    }

    public GalleryInVMAccessControlProfileVersionInner withExcludeFromLatest(Boolean excludeFromLatest) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryInVMAccessControlProfileVersionProperties();
        }
        this.innerProperties().withExcludeFromLatest(excludeFromLatest);
        return this;
    }

    public OffsetDateTime publishedDate() {
        return this.innerProperties() == null ? null : this.innerProperties().publishedDate();
    }

    public GalleryProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public ReplicationStatus replicationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationStatus();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static GalleryInVMAccessControlProfileVersionInner fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryInVMAccessControlProfileVersionInner)((Object)jsonReader.readObject(reader -> {
            GalleryInVMAccessControlProfileVersionInner deserializedGalleryInVMAccessControlProfileVersionInner = new GalleryInVMAccessControlProfileVersionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGalleryInVMAccessControlProfileVersionInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionInner.innerProperties = GalleryInVMAccessControlProfileVersionProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryInVMAccessControlProfileVersionInner;
        }));
    }
}

