/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CachingTypes;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetParameters;
import com.azure.resourcemanager.compute.models.ImageDisk;
import com.azure.resourcemanager.compute.models.OperatingSystemStateTypes;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.StorageAccountTypes;
import java.io.IOException;

public final class ImageOSDisk
extends ImageDisk {
    private OperatingSystemTypes osType;
    private OperatingSystemStateTypes osState;
    private static final ClientLogger LOGGER = new ClientLogger(ImageOSDisk.class);

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public ImageOSDisk withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public OperatingSystemStateTypes osState() {
        return this.osState;
    }

    public ImageOSDisk withOsState(OperatingSystemStateTypes osState) {
        this.osState = osState;
        return this;
    }

    @Override
    public ImageOSDisk withSnapshot(SubResource snapshot) {
        super.withSnapshot(snapshot);
        return this;
    }

    @Override
    public ImageOSDisk withManagedDisk(SubResource managedDisk) {
        super.withManagedDisk(managedDisk);
        return this;
    }

    @Override
    public ImageOSDisk withBlobUri(String blobUri) {
        super.withBlobUri(blobUri);
        return this;
    }

    @Override
    public ImageOSDisk withCaching(CachingTypes caching) {
        super.withCaching(caching);
        return this;
    }

    @Override
    public ImageOSDisk withDiskSizeGB(Integer diskSizeGB) {
        super.withDiskSizeGB(diskSizeGB);
        return this;
    }

    @Override
    public ImageOSDisk withStorageAccountType(StorageAccountTypes storageAccountType) {
        super.withStorageAccountType(storageAccountType);
        return this;
    }

    @Override
    public ImageOSDisk withDiskEncryptionSet(DiskEncryptionSetParameters diskEncryptionSet) {
        super.withDiskEncryptionSet(diskEncryptionSet);
        return this;
    }

    @Override
    public void validate() {
        if (this.osType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property osType in model ImageOSDisk"));
        }
        if (this.osState() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property osState in model ImageOSDisk"));
        }
        if (this.diskEncryptionSet() != null) {
            this.diskEncryptionSet().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("snapshot", (JsonSerializable)this.snapshot());
        jsonWriter.writeJsonField("managedDisk", (JsonSerializable)this.managedDisk());
        jsonWriter.writeStringField("blobUri", this.blobUri());
        jsonWriter.writeStringField("caching", this.caching() == null ? null : this.caching().toString());
        jsonWriter.writeNumberField("diskSizeGB", (Number)this.diskSizeGB());
        jsonWriter.writeStringField("storageAccountType", this.storageAccountType() == null ? null : this.storageAccountType().toString());
        jsonWriter.writeJsonField("diskEncryptionSet", (JsonSerializable)this.diskEncryptionSet());
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeStringField("osState", this.osState == null ? null : this.osState.toString());
        return jsonWriter.writeEndObject();
    }

    public static ImageOSDisk fromJson(JsonReader jsonReader) throws IOException {
        return (ImageOSDisk)jsonReader.readObject(reader -> {
            ImageOSDisk deserializedImageOSDisk = new ImageOSDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("snapshot".equals(fieldName)) {
                    deserializedImageOSDisk.withSnapshot(SubResource.fromJson((JsonReader)reader));
                    continue;
                }
                if ("managedDisk".equals(fieldName)) {
                    deserializedImageOSDisk.withManagedDisk(SubResource.fromJson((JsonReader)reader));
                    continue;
                }
                if ("blobUri".equals(fieldName)) {
                    deserializedImageOSDisk.withBlobUri(reader.getString());
                    continue;
                }
                if ("caching".equals(fieldName)) {
                    deserializedImageOSDisk.withCaching(CachingTypes.fromString(reader.getString()));
                    continue;
                }
                if ("diskSizeGB".equals(fieldName)) {
                    deserializedImageOSDisk.withDiskSizeGB((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("storageAccountType".equals(fieldName)) {
                    deserializedImageOSDisk.withStorageAccountType(StorageAccountTypes.fromString(reader.getString()));
                    continue;
                }
                if ("diskEncryptionSet".equals(fieldName)) {
                    deserializedImageOSDisk.withDiskEncryptionSet(DiskEncryptionSetParameters.fromJson(reader));
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    deserializedImageOSDisk.osType = OperatingSystemTypes.fromString(reader.getString());
                    continue;
                }
                if ("osState".equals(fieldName)) {
                    deserializedImageOSDisk.osState = OperatingSystemStateTypes.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImageOSDisk;
        });
    }
}

