/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.CapacityReservationGroupsClient;
import com.azure.resourcemanager.compute.fluent.models.CapacityReservationGroupInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.CapacityReservationGroupInstanceViewTypes;
import com.azure.resourcemanager.compute.models.CapacityReservationGroupListResult;
import com.azure.resourcemanager.compute.models.CapacityReservationGroupUpdate;
import com.azure.resourcemanager.compute.models.ExpandTypesForGetCapacityReservationGroups;
import com.azure.resourcemanager.compute.models.ResourceIdOptionsForGetCapacityReservationGroups;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import reactor.core.publisher.Mono;

public final class CapacityReservationGroupsClientImpl
implements InnerSupportsGet<CapacityReservationGroupInner>,
InnerSupportsListing<CapacityReservationGroupInner>,
InnerSupportsDelete<Void>,
CapacityReservationGroupsClient {
    private final CapacityReservationGroupsService service;
    private final ComputeManagementClientImpl client;

    CapacityReservationGroupsClientImpl(ComputeManagementClientImpl client) {
        this.service = (CapacityReservationGroupsService)RestProxy.create(CapacityReservationGroupsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CapacityReservationGroupInner>> listSinglePageAsync(ExpandTypesForGetCapacityReservationGroups expand, ResourceIdOptionsForGetCapacityReservationGroups resourceIdsOnly) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), expand, resourceIdsOnly, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CapacityReservationGroupListResult)res.getValue()).value(), ((CapacityReservationGroupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CapacityReservationGroupInner>> listSinglePageAsync(ExpandTypesForGetCapacityReservationGroups expand, ResourceIdOptionsForGetCapacityReservationGroups resourceIdsOnly, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), expand, resourceIdsOnly, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CapacityReservationGroupListResult)res.getValue()).value(), ((CapacityReservationGroupListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CapacityReservationGroupInner> listAsync(ExpandTypesForGetCapacityReservationGroups expand, ResourceIdOptionsForGetCapacityReservationGroups resourceIdsOnly) {
        return new PagedFlux(() -> this.listSinglePageAsync(expand, resourceIdsOnly), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CapacityReservationGroupInner> listAsync() {
        ExpandTypesForGetCapacityReservationGroups expand = null;
        ResourceIdOptionsForGetCapacityReservationGroups resourceIdsOnly = null;
        return new PagedFlux(() -> this.listSinglePageAsync(expand, resourceIdsOnly), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CapacityReservationGroupInner> listAsync(ExpandTypesForGetCapacityReservationGroups expand, ResourceIdOptionsForGetCapacityReservationGroups resourceIdsOnly, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(expand, resourceIdsOnly, context), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CapacityReservationGroupInner> list() {
        ExpandTypesForGetCapacityReservationGroups expand = null;
        ResourceIdOptionsForGetCapacityReservationGroups resourceIdsOnly = null;
        return new PagedIterable(this.listAsync(expand, resourceIdsOnly));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CapacityReservationGroupInner> list(ExpandTypesForGetCapacityReservationGroups expand, ResourceIdOptionsForGetCapacityReservationGroups resourceIdsOnly, Context context) {
        return new PagedIterable(this.listAsync(expand, resourceIdsOnly, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CapacityReservationGroupInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, ExpandTypesForGetCapacityReservationGroups expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, expand, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CapacityReservationGroupListResult)res.getValue()).value(), ((CapacityReservationGroupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CapacityReservationGroupInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, ExpandTypesForGetCapacityReservationGroups expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, expand, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CapacityReservationGroupListResult)res.getValue()).value(), ((CapacityReservationGroupListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CapacityReservationGroupInner> listByResourceGroupAsync(String resourceGroupName, ExpandTypesForGetCapacityReservationGroups expand) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, expand), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CapacityReservationGroupInner> listByResourceGroupAsync(String resourceGroupName) {
        ExpandTypesForGetCapacityReservationGroups expand = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, expand), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CapacityReservationGroupInner> listByResourceGroupAsync(String resourceGroupName, ExpandTypesForGetCapacityReservationGroups expand, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, expand, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CapacityReservationGroupInner> listByResourceGroup(String resourceGroupName) {
        ExpandTypesForGetCapacityReservationGroups expand = null;
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CapacityReservationGroupInner> listByResourceGroup(String resourceGroupName, ExpandTypesForGetCapacityReservationGroups expand, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, expand, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CapacityReservationGroupInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String capacityReservationGroupName, CapacityReservationGroupInstanceViewTypes expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (capacityReservationGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationGroupName is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, capacityReservationGroupName, expand, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CapacityReservationGroupInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String capacityReservationGroupName, CapacityReservationGroupInstanceViewTypes expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (capacityReservationGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationGroupName is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, capacityReservationGroupName, expand, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CapacityReservationGroupInner> getByResourceGroupAsync(String resourceGroupName, String capacityReservationGroupName) {
        CapacityReservationGroupInstanceViewTypes expand = null;
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, capacityReservationGroupName, expand).flatMap(res -> Mono.justOrEmpty((Object)((Object)((CapacityReservationGroupInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CapacityReservationGroupInner> getByResourceGroupWithResponse(String resourceGroupName, String capacityReservationGroupName, CapacityReservationGroupInstanceViewTypes expand, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, capacityReservationGroupName, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CapacityReservationGroupInner getByResourceGroup(String resourceGroupName, String capacityReservationGroupName) {
        CapacityReservationGroupInstanceViewTypes expand = null;
        return (CapacityReservationGroupInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, capacityReservationGroupName, expand, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CapacityReservationGroupInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String capacityReservationGroupName, CapacityReservationGroupInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (capacityReservationGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationGroupName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, capacityReservationGroupName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CapacityReservationGroupInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String capacityReservationGroupName, CapacityReservationGroupInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (capacityReservationGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationGroupName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, capacityReservationGroupName, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CapacityReservationGroupInner> createOrUpdateAsync(String resourceGroupName, String capacityReservationGroupName, CapacityReservationGroupInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, capacityReservationGroupName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((CapacityReservationGroupInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CapacityReservationGroupInner> createOrUpdateWithResponse(String resourceGroupName, String capacityReservationGroupName, CapacityReservationGroupInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, capacityReservationGroupName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CapacityReservationGroupInner createOrUpdate(String resourceGroupName, String capacityReservationGroupName, CapacityReservationGroupInner parameters) {
        return (CapacityReservationGroupInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, capacityReservationGroupName, parameters, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CapacityReservationGroupInner>> updateWithResponseAsync(String resourceGroupName, String capacityReservationGroupName, CapacityReservationGroupUpdate parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (capacityReservationGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationGroupName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, capacityReservationGroupName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CapacityReservationGroupInner>> updateWithResponseAsync(String resourceGroupName, String capacityReservationGroupName, CapacityReservationGroupUpdate parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (capacityReservationGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationGroupName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, capacityReservationGroupName, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CapacityReservationGroupInner> updateAsync(String resourceGroupName, String capacityReservationGroupName, CapacityReservationGroupUpdate parameters) {
        return this.updateWithResponseAsync(resourceGroupName, capacityReservationGroupName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((CapacityReservationGroupInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CapacityReservationGroupInner> updateWithResponse(String resourceGroupName, String capacityReservationGroupName, CapacityReservationGroupUpdate parameters, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, capacityReservationGroupName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CapacityReservationGroupInner update(String resourceGroupName, String capacityReservationGroupName, CapacityReservationGroupUpdate parameters) {
        return (CapacityReservationGroupInner)((Object)this.updateWithResponse(resourceGroupName, capacityReservationGroupName, parameters, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String capacityReservationGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (capacityReservationGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationGroupName is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, capacityReservationGroupName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String capacityReservationGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (capacityReservationGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter capacityReservationGroupName is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, capacityReservationGroupName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String capacityReservationGroupName) {
        return this.deleteWithResponseAsync(resourceGroupName, capacityReservationGroupName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String capacityReservationGroupName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, capacityReservationGroupName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String capacityReservationGroupName) {
        this.deleteWithResponse(resourceGroupName, capacityReservationGroupName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CapacityReservationGroupInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CapacityReservationGroupListResult)res.getValue()).value(), ((CapacityReservationGroupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CapacityReservationGroupInner>> listBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CapacityReservationGroupListResult)res.getValue()).value(), ((CapacityReservationGroupListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CapacityReservationGroupInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CapacityReservationGroupListResult)res.getValue()).value(), ((CapacityReservationGroupListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CapacityReservationGroupInner>> listByResourceGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CapacityReservationGroupListResult)res.getValue()).value(), ((CapacityReservationGroupListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementClientCapacityReservationGroups")
    public static interface CapacityReservationGroupsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/capacityReservationGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CapacityReservationGroupListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="$expand") ExpandTypesForGetCapacityReservationGroups var4, @QueryParam(value="resourceIdsOnly") ResourceIdOptionsForGetCapacityReservationGroups var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CapacityReservationGroupListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @QueryParam(value="$expand") ExpandTypesForGetCapacityReservationGroups var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups/{capacityReservationGroupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CapacityReservationGroupInner>> getByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="capacityReservationGroupName") String var5, @QueryParam(value="$expand") CapacityReservationGroupInstanceViewTypes var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups/{capacityReservationGroupName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CapacityReservationGroupInner>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="capacityReservationGroupName") String var5, @BodyParam(value="application/json") CapacityReservationGroupInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups/{capacityReservationGroupName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CapacityReservationGroupInner>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="capacityReservationGroupName") String var5, @BodyParam(value="application/json") CapacityReservationGroupUpdate var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/capacityReservationGroups/{capacityReservationGroupName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="capacityReservationGroupName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CapacityReservationGroupListResult>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CapacityReservationGroupListResult>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

