/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.azure.resourcemanager.compute.models.ProximityPlacementGroupPropertiesIntent;
import com.azure.resourcemanager.compute.models.ProximityPlacementGroupType;
import com.azure.resourcemanager.compute.models.SubResourceWithColocationStatus;
import java.io.IOException;
import java.util.List;

public final class ProximityPlacementGroupProperties
implements JsonSerializable<ProximityPlacementGroupProperties> {
    private ProximityPlacementGroupType proximityPlacementGroupType;
    private List<SubResourceWithColocationStatus> virtualMachines;
    private List<SubResourceWithColocationStatus> virtualMachineScaleSets;
    private List<SubResourceWithColocationStatus> availabilitySets;
    private InstanceViewStatus colocationStatus;
    private ProximityPlacementGroupPropertiesIntent intent;

    public ProximityPlacementGroupType proximityPlacementGroupType() {
        return this.proximityPlacementGroupType;
    }

    public ProximityPlacementGroupProperties withProximityPlacementGroupType(ProximityPlacementGroupType proximityPlacementGroupType) {
        this.proximityPlacementGroupType = proximityPlacementGroupType;
        return this;
    }

    public List<SubResourceWithColocationStatus> virtualMachines() {
        return this.virtualMachines;
    }

    public List<SubResourceWithColocationStatus> virtualMachineScaleSets() {
        return this.virtualMachineScaleSets;
    }

    public List<SubResourceWithColocationStatus> availabilitySets() {
        return this.availabilitySets;
    }

    public InstanceViewStatus colocationStatus() {
        return this.colocationStatus;
    }

    public ProximityPlacementGroupProperties withColocationStatus(InstanceViewStatus colocationStatus) {
        this.colocationStatus = colocationStatus;
        return this;
    }

    public ProximityPlacementGroupPropertiesIntent intent() {
        return this.intent;
    }

    public ProximityPlacementGroupProperties withIntent(ProximityPlacementGroupPropertiesIntent intent) {
        this.intent = intent;
        return this;
    }

    public void validate() {
        if (this.virtualMachines() != null) {
            this.virtualMachines().forEach(e -> e.validate());
        }
        if (this.virtualMachineScaleSets() != null) {
            this.virtualMachineScaleSets().forEach(e -> e.validate());
        }
        if (this.availabilitySets() != null) {
            this.availabilitySets().forEach(e -> e.validate());
        }
        if (this.colocationStatus() != null) {
            this.colocationStatus().validate();
        }
        if (this.intent() != null) {
            this.intent().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("proximityPlacementGroupType", this.proximityPlacementGroupType == null ? null : this.proximityPlacementGroupType.toString());
        jsonWriter.writeJsonField("colocationStatus", (JsonSerializable)this.colocationStatus);
        jsonWriter.writeJsonField("intent", (JsonSerializable)this.intent);
        return jsonWriter.writeEndObject();
    }

    public static ProximityPlacementGroupProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ProximityPlacementGroupProperties)jsonReader.readObject(reader -> {
            ProximityPlacementGroupProperties deserializedProximityPlacementGroupProperties = new ProximityPlacementGroupProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("proximityPlacementGroupType".equals(fieldName)) {
                    deserializedProximityPlacementGroupProperties.proximityPlacementGroupType = ProximityPlacementGroupType.fromString(reader.getString());
                    continue;
                }
                if ("virtualMachines".equals(fieldName)) {
                    List virtualMachines;
                    deserializedProximityPlacementGroupProperties.virtualMachines = virtualMachines = reader.readArray(reader1 -> SubResourceWithColocationStatus.fromJson(reader1));
                    continue;
                }
                if ("virtualMachineScaleSets".equals(fieldName)) {
                    List virtualMachineScaleSets;
                    deserializedProximityPlacementGroupProperties.virtualMachineScaleSets = virtualMachineScaleSets = reader.readArray(reader1 -> SubResourceWithColocationStatus.fromJson(reader1));
                    continue;
                }
                if ("availabilitySets".equals(fieldName)) {
                    List availabilitySets;
                    deserializedProximityPlacementGroupProperties.availabilitySets = availabilitySets = reader.readArray(reader1 -> SubResourceWithColocationStatus.fromJson(reader1));
                    continue;
                }
                if ("colocationStatus".equals(fieldName)) {
                    deserializedProximityPlacementGroupProperties.colocationStatus = InstanceViewStatus.fromJson(reader);
                    continue;
                }
                if ("intent".equals(fieldName)) {
                    deserializedProximityPlacementGroupProperties.intent = ProximityPlacementGroupPropertiesIntent.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProximityPlacementGroupProperties;
        });
    }
}

