/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.InstanceViewStatusesSummary;
import com.azure.resourcemanager.compute.models.ResourceInstanceViewStatus;
import java.io.IOException;
import java.util.List;

public final class CloudServiceInstanceViewInner
implements JsonSerializable<CloudServiceInstanceViewInner> {
    private InstanceViewStatusesSummary roleInstance;
    private String sdkVersion;
    private List<String> privateIds;
    private List<ResourceInstanceViewStatus> statuses;

    public InstanceViewStatusesSummary roleInstance() {
        return this.roleInstance;
    }

    public CloudServiceInstanceViewInner withRoleInstance(InstanceViewStatusesSummary roleInstance) {
        this.roleInstance = roleInstance;
        return this;
    }

    public String sdkVersion() {
        return this.sdkVersion;
    }

    public List<String> privateIds() {
        return this.privateIds;
    }

    public List<ResourceInstanceViewStatus> statuses() {
        return this.statuses;
    }

    public void validate() {
        if (this.roleInstance() != null) {
            this.roleInstance().validate();
        }
        if (this.statuses() != null) {
            this.statuses().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("roleInstance", (JsonSerializable)this.roleInstance);
        return jsonWriter.writeEndObject();
    }

    public static CloudServiceInstanceViewInner fromJson(JsonReader jsonReader) throws IOException {
        return (CloudServiceInstanceViewInner)jsonReader.readObject(reader -> {
            CloudServiceInstanceViewInner deserializedCloudServiceInstanceViewInner = new CloudServiceInstanceViewInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("roleInstance".equals(fieldName)) {
                    deserializedCloudServiceInstanceViewInner.roleInstance = InstanceViewStatusesSummary.fromJson(reader);
                    continue;
                }
                if ("sdkVersion".equals(fieldName)) {
                    deserializedCloudServiceInstanceViewInner.sdkVersion = reader.getString();
                    continue;
                }
                if ("privateIds".equals(fieldName)) {
                    List privateIds;
                    deserializedCloudServiceInstanceViewInner.privateIds = privateIds = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("statuses".equals(fieldName)) {
                    List statuses;
                    deserializedCloudServiceInstanceViewInner.statuses = statuses = reader.readArray(reader1 -> ResourceInstanceViewStatus.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudServiceInstanceViewInner;
        });
    }
}

