/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.ApiEntityReference;
import com.azure.resourcemanager.compute.models.NetworkApiVersion;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetUpdateNetworkConfiguration;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineScaleSetUpdateNetworkProfile
implements JsonSerializable<VirtualMachineScaleSetUpdateNetworkProfile> {
    private ApiEntityReference healthProbe;
    private List<VirtualMachineScaleSetUpdateNetworkConfiguration> networkInterfaceConfigurations;
    private NetworkApiVersion networkApiVersion;

    public ApiEntityReference healthProbe() {
        return this.healthProbe;
    }

    public VirtualMachineScaleSetUpdateNetworkProfile withHealthProbe(ApiEntityReference healthProbe) {
        this.healthProbe = healthProbe;
        return this;
    }

    public List<VirtualMachineScaleSetUpdateNetworkConfiguration> networkInterfaceConfigurations() {
        return this.networkInterfaceConfigurations;
    }

    public VirtualMachineScaleSetUpdateNetworkProfile withNetworkInterfaceConfigurations(List<VirtualMachineScaleSetUpdateNetworkConfiguration> networkInterfaceConfigurations) {
        this.networkInterfaceConfigurations = networkInterfaceConfigurations;
        return this;
    }

    public NetworkApiVersion networkApiVersion() {
        return this.networkApiVersion;
    }

    public VirtualMachineScaleSetUpdateNetworkProfile withNetworkApiVersion(NetworkApiVersion networkApiVersion) {
        this.networkApiVersion = networkApiVersion;
        return this;
    }

    public void validate() {
        if (this.healthProbe() != null) {
            this.healthProbe().validate();
        }
        if (this.networkInterfaceConfigurations() != null) {
            this.networkInterfaceConfigurations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("healthProbe", (JsonSerializable)this.healthProbe);
        jsonWriter.writeArrayField("networkInterfaceConfigurations", this.networkInterfaceConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("networkApiVersion", this.networkApiVersion == null ? null : this.networkApiVersion.toString());
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetUpdateNetworkProfile fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetUpdateNetworkProfile)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetUpdateNetworkProfile deserializedVirtualMachineScaleSetUpdateNetworkProfile = new VirtualMachineScaleSetUpdateNetworkProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("healthProbe".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateNetworkProfile.healthProbe = ApiEntityReference.fromJson(reader);
                    continue;
                }
                if ("networkInterfaceConfigurations".equals(fieldName)) {
                    List networkInterfaceConfigurations;
                    deserializedVirtualMachineScaleSetUpdateNetworkProfile.networkInterfaceConfigurations = networkInterfaceConfigurations = reader.readArray(reader1 -> VirtualMachineScaleSetUpdateNetworkConfiguration.fromJson(reader1));
                    continue;
                }
                if ("networkApiVersion".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetUpdateNetworkProfile.networkApiVersion = NetworkApiVersion.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetUpdateNetworkProfile;
        });
    }
}

