/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.AvailablePatchSummary;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.azure.resourcemanager.compute.models.LastPatchInstallationSummary;
import java.io.IOException;
import java.util.List;

public final class VirtualMachinePatchStatus
implements JsonSerializable<VirtualMachinePatchStatus> {
    private AvailablePatchSummary availablePatchSummary;
    private LastPatchInstallationSummary lastPatchInstallationSummary;
    private List<InstanceViewStatus> configurationStatuses;

    public AvailablePatchSummary availablePatchSummary() {
        return this.availablePatchSummary;
    }

    public VirtualMachinePatchStatus withAvailablePatchSummary(AvailablePatchSummary availablePatchSummary) {
        this.availablePatchSummary = availablePatchSummary;
        return this;
    }

    public LastPatchInstallationSummary lastPatchInstallationSummary() {
        return this.lastPatchInstallationSummary;
    }

    public VirtualMachinePatchStatus withLastPatchInstallationSummary(LastPatchInstallationSummary lastPatchInstallationSummary) {
        this.lastPatchInstallationSummary = lastPatchInstallationSummary;
        return this;
    }

    public List<InstanceViewStatus> configurationStatuses() {
        return this.configurationStatuses;
    }

    public void validate() {
        if (this.availablePatchSummary() != null) {
            this.availablePatchSummary().validate();
        }
        if (this.lastPatchInstallationSummary() != null) {
            this.lastPatchInstallationSummary().validate();
        }
        if (this.configurationStatuses() != null) {
            this.configurationStatuses().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("availablePatchSummary", (JsonSerializable)this.availablePatchSummary);
        jsonWriter.writeJsonField("lastPatchInstallationSummary", (JsonSerializable)this.lastPatchInstallationSummary);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachinePatchStatus fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachinePatchStatus)jsonReader.readObject(reader -> {
            VirtualMachinePatchStatus deserializedVirtualMachinePatchStatus = new VirtualMachinePatchStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("availablePatchSummary".equals(fieldName)) {
                    deserializedVirtualMachinePatchStatus.availablePatchSummary = AvailablePatchSummary.fromJson(reader);
                    continue;
                }
                if ("lastPatchInstallationSummary".equals(fieldName)) {
                    deserializedVirtualMachinePatchStatus.lastPatchInstallationSummary = LastPatchInstallationSummary.fromJson(reader);
                    continue;
                }
                if ("configurationStatuses".equals(fieldName)) {
                    List configurationStatuses;
                    deserializedVirtualMachinePatchStatus.configurationStatuses = configurationStatuses = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachinePatchStatus;
        });
    }
}

