/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DiskEncryptionSettings;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import java.io.IOException;
import java.util.List;

public final class DiskInstanceView
implements JsonSerializable<DiskInstanceView> {
    private String name;
    private List<DiskEncryptionSettings> encryptionSettings;
    private List<InstanceViewStatus> statuses;

    public String name() {
        return this.name;
    }

    public DiskInstanceView withName(String name) {
        this.name = name;
        return this;
    }

    public List<DiskEncryptionSettings> encryptionSettings() {
        return this.encryptionSettings;
    }

    public DiskInstanceView withEncryptionSettings(List<DiskEncryptionSettings> encryptionSettings) {
        this.encryptionSettings = encryptionSettings;
        return this;
    }

    public List<InstanceViewStatus> statuses() {
        return this.statuses;
    }

    public DiskInstanceView withStatuses(List<InstanceViewStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    public void validate() {
        if (this.encryptionSettings() != null) {
            this.encryptionSettings().forEach(e -> e.validate());
        }
        if (this.statuses() != null) {
            this.statuses().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("encryptionSettings", this.encryptionSettings, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("statuses", this.statuses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DiskInstanceView fromJson(JsonReader jsonReader) throws IOException {
        return (DiskInstanceView)jsonReader.readObject(reader -> {
            DiskInstanceView deserializedDiskInstanceView = new DiskInstanceView();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedDiskInstanceView.name = reader.getString();
                    continue;
                }
                if ("encryptionSettings".equals(fieldName)) {
                    List encryptionSettings;
                    deserializedDiskInstanceView.encryptionSettings = encryptionSettings = reader.readArray(reader1 -> DiskEncryptionSettings.fromJson(reader1));
                    continue;
                }
                if ("statuses".equals(fieldName)) {
                    List statuses;
                    deserializedDiskInstanceView.statuses = statuses = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiskInstanceView;
        });
    }
}

