/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DedicatedHostAvailableCapacity;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import java.io.IOException;
import java.util.List;

public class DedicatedHostInstanceView
implements JsonSerializable<DedicatedHostInstanceView> {
    private String assetId;
    private DedicatedHostAvailableCapacity availableCapacity;
    private List<InstanceViewStatus> statuses;

    public String assetId() {
        return this.assetId;
    }

    DedicatedHostInstanceView withAssetId(String assetId) {
        this.assetId = assetId;
        return this;
    }

    public DedicatedHostAvailableCapacity availableCapacity() {
        return this.availableCapacity;
    }

    public DedicatedHostInstanceView withAvailableCapacity(DedicatedHostAvailableCapacity availableCapacity) {
        this.availableCapacity = availableCapacity;
        return this;
    }

    public List<InstanceViewStatus> statuses() {
        return this.statuses;
    }

    public DedicatedHostInstanceView withStatuses(List<InstanceViewStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    public void validate() {
        if (this.availableCapacity() != null) {
            this.availableCapacity().validate();
        }
        if (this.statuses() != null) {
            this.statuses().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("availableCapacity", (JsonSerializable)this.availableCapacity);
        jsonWriter.writeArrayField("statuses", this.statuses, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DedicatedHostInstanceView fromJson(JsonReader jsonReader) throws IOException {
        return (DedicatedHostInstanceView)jsonReader.readObject(reader -> {
            DedicatedHostInstanceView deserializedDedicatedHostInstanceView = new DedicatedHostInstanceView();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("assetId".equals(fieldName)) {
                    deserializedDedicatedHostInstanceView.assetId = reader.getString();
                    continue;
                }
                if ("availableCapacity".equals(fieldName)) {
                    deserializedDedicatedHostInstanceView.availableCapacity = DedicatedHostAvailableCapacity.fromJson(reader);
                    continue;
                }
                if ("statuses".equals(fieldName)) {
                    List statuses;
                    deserializedDedicatedHostInstanceView.statuses = statuses = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDedicatedHostInstanceView;
        });
    }
}

