/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.AvailabilitySetsClient;
import com.azure.resourcemanager.compute.fluent.models.AvailabilitySetInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineSizeInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.AvailabilitySetListResult;
import com.azure.resourcemanager.compute.models.AvailabilitySetUpdate;
import com.azure.resourcemanager.compute.models.ConvertToVirtualMachineScaleSetInput;
import com.azure.resourcemanager.compute.models.MigrateToVirtualMachineScaleSetInput;
import com.azure.resourcemanager.compute.models.VirtualMachineSizeListResult;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AvailabilitySetsClientImpl
implements InnerSupportsGet<AvailabilitySetInner>,
InnerSupportsListing<AvailabilitySetInner>,
InnerSupportsDelete<Void>,
AvailabilitySetsClient {
    private final AvailabilitySetsService service;
    private final ComputeManagementClientImpl client;

    AvailabilitySetsClientImpl(ComputeManagementClientImpl client) {
        this.service = (AvailabilitySetsService)RestProxy.create(AvailabilitySetsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AvailabilitySetInner>> listSinglePageAsync(String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), expand, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvailabilitySetListResult)res.getValue()).value(), ((AvailabilitySetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AvailabilitySetInner>> listSinglePageAsync(String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), expand, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvailabilitySetListResult)res.getValue()).value(), ((AvailabilitySetListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AvailabilitySetInner> listAsync(String expand) {
        return new PagedFlux(() -> this.listSinglePageAsync(expand), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AvailabilitySetInner> listAsync() {
        String expand = null;
        return new PagedFlux(() -> this.listSinglePageAsync(expand), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AvailabilitySetInner> listAsync(String expand, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(expand, context), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AvailabilitySetInner> list() {
        String expand = null;
        return new PagedIterable(this.listAsync(expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AvailabilitySetInner> list(String expand, Context context) {
        return new PagedIterable(this.listAsync(expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AvailabilitySetInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvailabilitySetListResult)res.getValue()).value(), ((AvailabilitySetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AvailabilitySetInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvailabilitySetListResult)res.getValue()).value(), ((AvailabilitySetListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AvailabilitySetInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AvailabilitySetInner> listByResourceGroupAsync(String resourceGroupName, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AvailabilitySetInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AvailabilitySetInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AvailabilitySetInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String availabilitySetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (availabilitySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availabilitySetName is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, availabilitySetName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AvailabilitySetInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String availabilitySetName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (availabilitySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availabilitySetName is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, availabilitySetName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AvailabilitySetInner> getByResourceGroupAsync(String resourceGroupName, String availabilitySetName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, availabilitySetName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AvailabilitySetInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AvailabilitySetInner> getByResourceGroupWithResponse(String resourceGroupName, String availabilitySetName, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, availabilitySetName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AvailabilitySetInner getByResourceGroup(String resourceGroupName, String availabilitySetName) {
        return (AvailabilitySetInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, availabilitySetName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AvailabilitySetInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String availabilitySetName, AvailabilitySetInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (availabilitySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availabilitySetName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, availabilitySetName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AvailabilitySetInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String availabilitySetName, AvailabilitySetInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (availabilitySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availabilitySetName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, availabilitySetName, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AvailabilitySetInner> createOrUpdateAsync(String resourceGroupName, String availabilitySetName, AvailabilitySetInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, availabilitySetName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AvailabilitySetInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AvailabilitySetInner> createOrUpdateWithResponse(String resourceGroupName, String availabilitySetName, AvailabilitySetInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, availabilitySetName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AvailabilitySetInner createOrUpdate(String resourceGroupName, String availabilitySetName, AvailabilitySetInner parameters) {
        return (AvailabilitySetInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, availabilitySetName, parameters, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AvailabilitySetInner>> updateWithResponseAsync(String resourceGroupName, String availabilitySetName, AvailabilitySetUpdate parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (availabilitySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availabilitySetName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, availabilitySetName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AvailabilitySetInner>> updateWithResponseAsync(String resourceGroupName, String availabilitySetName, AvailabilitySetUpdate parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (availabilitySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availabilitySetName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, availabilitySetName, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AvailabilitySetInner> updateAsync(String resourceGroupName, String availabilitySetName, AvailabilitySetUpdate parameters) {
        return this.updateWithResponseAsync(resourceGroupName, availabilitySetName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((AvailabilitySetInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AvailabilitySetInner> updateWithResponse(String resourceGroupName, String availabilitySetName, AvailabilitySetUpdate parameters, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, availabilitySetName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AvailabilitySetInner update(String resourceGroupName, String availabilitySetName, AvailabilitySetUpdate parameters) {
        return (AvailabilitySetInner)((Object)this.updateWithResponse(resourceGroupName, availabilitySetName, parameters, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String availabilitySetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (availabilitySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availabilitySetName is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, availabilitySetName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String availabilitySetName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (availabilitySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availabilitySetName is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, availabilitySetName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String availabilitySetName) {
        return this.deleteWithResponseAsync(resourceGroupName, availabilitySetName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String availabilitySetName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, availabilitySetName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String availabilitySetName) {
        this.deleteWithResponse(resourceGroupName, availabilitySetName, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelMigrationToVirtualMachineScaleSetWithResponseAsync(String resourceGroupName, String availabilitySetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (availabilitySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availabilitySetName is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelMigrationToVirtualMachineScaleSet(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, availabilitySetName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> cancelMigrationToVirtualMachineScaleSetWithResponseAsync(String resourceGroupName, String availabilitySetName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (availabilitySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availabilitySetName is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.cancelMigrationToVirtualMachineScaleSet(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, availabilitySetName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelMigrationToVirtualMachineScaleSetAsync(String resourceGroupName, String availabilitySetName) {
        return this.cancelMigrationToVirtualMachineScaleSetWithResponseAsync(resourceGroupName, availabilitySetName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelMigrationToVirtualMachineScaleSetWithResponse(String resourceGroupName, String availabilitySetName, Context context) {
        return (Response)this.cancelMigrationToVirtualMachineScaleSetWithResponseAsync(resourceGroupName, availabilitySetName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelMigrationToVirtualMachineScaleSet(String resourceGroupName, String availabilitySetName) {
        this.cancelMigrationToVirtualMachineScaleSetWithResponse(resourceGroupName, availabilitySetName, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> convertToVirtualMachineScaleSetWithResponseAsync(String resourceGroupName, String availabilitySetName, ConvertToVirtualMachineScaleSetInput parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (availabilitySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availabilitySetName is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.convertToVirtualMachineScaleSet(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, availabilitySetName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> convertToVirtualMachineScaleSetWithResponseAsync(String resourceGroupName, String availabilitySetName, ConvertToVirtualMachineScaleSetInput parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (availabilitySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availabilitySetName is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.convertToVirtualMachineScaleSet(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, availabilitySetName, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginConvertToVirtualMachineScaleSetAsync(String resourceGroupName, String availabilitySetName, ConvertToVirtualMachineScaleSetInput parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.convertToVirtualMachineScaleSetWithResponseAsync(resourceGroupName, availabilitySetName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginConvertToVirtualMachineScaleSetAsync(String resourceGroupName, String availabilitySetName) {
        ConvertToVirtualMachineScaleSetInput parameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.convertToVirtualMachineScaleSetWithResponseAsync(resourceGroupName, availabilitySetName, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginConvertToVirtualMachineScaleSetAsync(String resourceGroupName, String availabilitySetName, ConvertToVirtualMachineScaleSetInput parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.convertToVirtualMachineScaleSetWithResponseAsync(resourceGroupName, availabilitySetName, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginConvertToVirtualMachineScaleSet(String resourceGroupName, String availabilitySetName) {
        ConvertToVirtualMachineScaleSetInput parameters = null;
        return this.beginConvertToVirtualMachineScaleSetAsync(resourceGroupName, availabilitySetName, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginConvertToVirtualMachineScaleSet(String resourceGroupName, String availabilitySetName, ConvertToVirtualMachineScaleSetInput parameters, Context context) {
        return this.beginConvertToVirtualMachineScaleSetAsync(resourceGroupName, availabilitySetName, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> convertToVirtualMachineScaleSetAsync(String resourceGroupName, String availabilitySetName, ConvertToVirtualMachineScaleSetInput parameters) {
        return this.beginConvertToVirtualMachineScaleSetAsync(resourceGroupName, availabilitySetName, parameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> convertToVirtualMachineScaleSetAsync(String resourceGroupName, String availabilitySetName) {
        ConvertToVirtualMachineScaleSetInput parameters = null;
        return this.beginConvertToVirtualMachineScaleSetAsync(resourceGroupName, availabilitySetName, parameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> convertToVirtualMachineScaleSetAsync(String resourceGroupName, String availabilitySetName, ConvertToVirtualMachineScaleSetInput parameters, Context context) {
        return this.beginConvertToVirtualMachineScaleSetAsync(resourceGroupName, availabilitySetName, parameters, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void convertToVirtualMachineScaleSet(String resourceGroupName, String availabilitySetName) {
        ConvertToVirtualMachineScaleSetInput parameters = null;
        this.convertToVirtualMachineScaleSetAsync(resourceGroupName, availabilitySetName, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void convertToVirtualMachineScaleSet(String resourceGroupName, String availabilitySetName, ConvertToVirtualMachineScaleSetInput parameters, Context context) {
        this.convertToVirtualMachineScaleSetAsync(resourceGroupName, availabilitySetName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startMigrationToVirtualMachineScaleSetWithResponseAsync(String resourceGroupName, String availabilitySetName, MigrateToVirtualMachineScaleSetInput parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (availabilitySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availabilitySetName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.startMigrationToVirtualMachineScaleSet(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, availabilitySetName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> startMigrationToVirtualMachineScaleSetWithResponseAsync(String resourceGroupName, String availabilitySetName, MigrateToVirtualMachineScaleSetInput parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (availabilitySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availabilitySetName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.startMigrationToVirtualMachineScaleSet(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, availabilitySetName, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startMigrationToVirtualMachineScaleSetAsync(String resourceGroupName, String availabilitySetName, MigrateToVirtualMachineScaleSetInput parameters) {
        return this.startMigrationToVirtualMachineScaleSetWithResponseAsync(resourceGroupName, availabilitySetName, parameters).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> startMigrationToVirtualMachineScaleSetWithResponse(String resourceGroupName, String availabilitySetName, MigrateToVirtualMachineScaleSetInput parameters, Context context) {
        return (Response)this.startMigrationToVirtualMachineScaleSetWithResponseAsync(resourceGroupName, availabilitySetName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void startMigrationToVirtualMachineScaleSet(String resourceGroupName, String availabilitySetName, MigrateToVirtualMachineScaleSetInput parameters) {
        this.startMigrationToVirtualMachineScaleSetWithResponse(resourceGroupName, availabilitySetName, parameters, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> validateMigrationToVirtualMachineScaleSetWithResponseAsync(String resourceGroupName, String availabilitySetName, MigrateToVirtualMachineScaleSetInput parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (availabilitySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availabilitySetName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateMigrationToVirtualMachineScaleSet(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, availabilitySetName, parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> validateMigrationToVirtualMachineScaleSetWithResponseAsync(String resourceGroupName, String availabilitySetName, MigrateToVirtualMachineScaleSetInput parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (availabilitySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availabilitySetName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateMigrationToVirtualMachineScaleSet(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, availabilitySetName, parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> validateMigrationToVirtualMachineScaleSetAsync(String resourceGroupName, String availabilitySetName, MigrateToVirtualMachineScaleSetInput parameters) {
        return this.validateMigrationToVirtualMachineScaleSetWithResponseAsync(resourceGroupName, availabilitySetName, parameters).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> validateMigrationToVirtualMachineScaleSetWithResponse(String resourceGroupName, String availabilitySetName, MigrateToVirtualMachineScaleSetInput parameters, Context context) {
        return (Response)this.validateMigrationToVirtualMachineScaleSetWithResponseAsync(resourceGroupName, availabilitySetName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void validateMigrationToVirtualMachineScaleSet(String resourceGroupName, String availabilitySetName, MigrateToVirtualMachineScaleSetInput parameters) {
        this.validateMigrationToVirtualMachineScaleSetWithResponse(resourceGroupName, availabilitySetName, parameters, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineSizeInner>> listAvailableSizesSinglePageAsync(String resourceGroupName, String availabilitySetName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (availabilitySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availabilitySetName is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAvailableSizes(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, availabilitySetName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineSizeListResult)res.getValue()).value(), ((VirtualMachineSizeListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineSizeInner>> listAvailableSizesSinglePageAsync(String resourceGroupName, String availabilitySetName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (availabilitySetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter availabilitySetName is required and cannot be null."));
        }
        String apiVersion = "2025-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAvailableSizes(this.client.getEndpoint(), "2025-04-01", this.client.getSubscriptionId(), resourceGroupName, availabilitySetName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineSizeListResult)res.getValue()).value(), ((VirtualMachineSizeListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VirtualMachineSizeInner> listAvailableSizesAsync(String resourceGroupName, String availabilitySetName) {
        return new PagedFlux(() -> this.listAvailableSizesSinglePageAsync(resourceGroupName, availabilitySetName), nextLink -> this.listAvailableSizesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VirtualMachineSizeInner> listAvailableSizesAsync(String resourceGroupName, String availabilitySetName, Context context) {
        return new PagedFlux(() -> this.listAvailableSizesSinglePageAsync(resourceGroupName, availabilitySetName, context), nextLink -> this.listAvailableSizesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualMachineSizeInner> listAvailableSizes(String resourceGroupName, String availabilitySetName) {
        return new PagedIterable(this.listAvailableSizesAsync(resourceGroupName, availabilitySetName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualMachineSizeInner> listAvailableSizes(String resourceGroupName, String availabilitySetName, Context context) {
        return new PagedIterable(this.listAvailableSizesAsync(resourceGroupName, availabilitySetName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AvailabilitySetInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvailabilitySetListResult)res.getValue()).value(), ((AvailabilitySetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AvailabilitySetInner>> listBySubscriptionNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvailabilitySetListResult)res.getValue()).value(), ((AvailabilitySetListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AvailabilitySetInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvailabilitySetListResult)res.getValue()).value(), ((AvailabilitySetListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AvailabilitySetInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AvailabilitySetListResult)res.getValue()).value(), ((AvailabilitySetListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineSizeInner>> listAvailableSizesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAvailableSizesNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineSizeListResult)res.getValue()).value(), ((VirtualMachineSizeListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineSizeInner>> listAvailableSizesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAvailableSizesNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineSizeListResult)res.getValue()).value(), ((VirtualMachineSizeListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementClientAvailabilitySets")
    public static interface AvailabilitySetsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/availabilitySets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<AvailabilitySetListResult>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<AvailabilitySetListResult>> listByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<AvailabilitySetInner>> getByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="availabilitySetName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<AvailabilitySetInner>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="availabilitySetName") String var5, @BodyParam(value="application/json") AvailabilitySetInner var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<AvailabilitySetInner>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="availabilitySetName") String var5, @BodyParam(value="application/json") AvailabilitySetUpdate var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="availabilitySetName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}/cancelMigrationToVirtualMachineScaleSet")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Void>> cancelMigrationToVirtualMachineScaleSet(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="availabilitySetName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}/convertToVirtualMachineScaleSet")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> convertToVirtualMachineScaleSet(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="availabilitySetName") String var5, @BodyParam(value="application/json") ConvertToVirtualMachineScaleSetInput var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}/startMigrationToVirtualMachineScaleSet")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Void>> startMigrationToVirtualMachineScaleSet(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="availabilitySetName") String var5, @BodyParam(value="application/json") MigrateToVirtualMachineScaleSetInput var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}/validateMigrationToVirtualMachineScaleSet")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Void>> validateMigrationToVirtualMachineScaleSet(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="availabilitySetName") String var5, @BodyParam(value="application/json") MigrateToVirtualMachineScaleSetInput var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/availabilitySets/{availabilitySetName}/vmSizes")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<VirtualMachineSizeListResult>> listAvailableSizes(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="availabilitySetName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<AvailabilitySetListResult>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<AvailabilitySetListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<VirtualMachineSizeListResult>> listAvailableSizesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

