/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.RestorePointProperties;
import com.azure.resourcemanager.compute.models.ApiEntityReference;
import com.azure.resourcemanager.compute.models.ConsistencyModeTypes;
import com.azure.resourcemanager.compute.models.RestorePointInstanceView;
import com.azure.resourcemanager.compute.models.RestorePointSourceMetadata;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class RestorePointInner
extends ProxyResource {
    private RestorePointProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private RestorePointProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public List<ApiEntityReference> excludeDisks() {
        return this.innerProperties() == null ? null : this.innerProperties().excludeDisks();
    }

    public RestorePointInner withExcludeDisks(List<ApiEntityReference> excludeDisks) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorePointProperties();
        }
        this.innerProperties().withExcludeDisks(excludeDisks);
        return this;
    }

    public RestorePointSourceMetadata sourceMetadata() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceMetadata();
    }

    public RestorePointInner withSourceMetadata(RestorePointSourceMetadata sourceMetadata) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorePointProperties();
        }
        this.innerProperties().withSourceMetadata(sourceMetadata);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public ConsistencyModeTypes consistencyMode() {
        return this.innerProperties() == null ? null : this.innerProperties().consistencyMode();
    }

    public RestorePointInner withConsistencyMode(ConsistencyModeTypes consistencyMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorePointProperties();
        }
        this.innerProperties().withConsistencyMode(consistencyMode);
        return this;
    }

    public OffsetDateTime timeCreated() {
        return this.innerProperties() == null ? null : this.innerProperties().timeCreated();
    }

    public RestorePointInner withTimeCreated(OffsetDateTime timeCreated) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorePointProperties();
        }
        this.innerProperties().withTimeCreated(timeCreated);
        return this;
    }

    public ApiEntityReference sourceRestorePoint() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceRestorePoint();
    }

    public RestorePointInner withSourceRestorePoint(ApiEntityReference sourceRestorePoint) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RestorePointProperties();
        }
        this.innerProperties().withSourceRestorePoint(sourceRestorePoint);
        return this;
    }

    public RestorePointInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RestorePointInner fromJson(JsonReader jsonReader) throws IOException {
        return (RestorePointInner)((Object)jsonReader.readObject(reader -> {
            RestorePointInner deserializedRestorePointInner = new RestorePointInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRestorePointInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRestorePointInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRestorePointInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRestorePointInner.innerProperties = RestorePointProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedRestorePointInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRestorePointInner;
        }));
    }
}

