/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.DiskEncryptionSetUpdateProperties;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetType;
import com.azure.resourcemanager.compute.models.EncryptionSetIdentity;
import com.azure.resourcemanager.compute.models.KeyForDiskEncryptionSet;
import java.io.IOException;
import java.util.Map;

public final class DiskEncryptionSetUpdate
implements JsonSerializable<DiskEncryptionSetUpdate> {
    private DiskEncryptionSetUpdateProperties innerProperties;
    private Map<String, String> tags;
    private EncryptionSetIdentity identity;

    private DiskEncryptionSetUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public DiskEncryptionSetUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public EncryptionSetIdentity identity() {
        return this.identity;
    }

    public DiskEncryptionSetUpdate withIdentity(EncryptionSetIdentity identity) {
        this.identity = identity;
        return this;
    }

    public DiskEncryptionSetType encryptionType() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionType();
    }

    public DiskEncryptionSetUpdate withEncryptionType(DiskEncryptionSetType encryptionType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskEncryptionSetUpdateProperties();
        }
        this.innerProperties().withEncryptionType(encryptionType);
        return this;
    }

    public KeyForDiskEncryptionSet activeKey() {
        return this.innerProperties() == null ? null : this.innerProperties().activeKey();
    }

    public DiskEncryptionSetUpdate withActiveKey(KeyForDiskEncryptionSet activeKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskEncryptionSetUpdateProperties();
        }
        this.innerProperties().withActiveKey(activeKey);
        return this;
    }

    public Boolean rotationToLatestKeyVersionEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().rotationToLatestKeyVersionEnabled();
    }

    public DiskEncryptionSetUpdate withRotationToLatestKeyVersionEnabled(Boolean rotationToLatestKeyVersionEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskEncryptionSetUpdateProperties();
        }
        this.innerProperties().withRotationToLatestKeyVersionEnabled(rotationToLatestKeyVersionEnabled);
        return this;
    }

    public String federatedClientId() {
        return this.innerProperties() == null ? null : this.innerProperties().federatedClientId();
    }

    public DiskEncryptionSetUpdate withFederatedClientId(String federatedClientId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskEncryptionSetUpdateProperties();
        }
        this.innerProperties().withFederatedClientId(federatedClientId);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static DiskEncryptionSetUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (DiskEncryptionSetUpdate)jsonReader.readObject(reader -> {
            DiskEncryptionSetUpdate deserializedDiskEncryptionSetUpdate = new DiskEncryptionSetUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedDiskEncryptionSetUpdate.innerProperties = DiskEncryptionSetUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedDiskEncryptionSetUpdate.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedDiskEncryptionSetUpdate.identity = EncryptionSetIdentity.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDiskEncryptionSetUpdate;
        });
    }
}

