/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class AccessControlRulesRole
implements JsonSerializable<AccessControlRulesRole> {
    private String name;
    private List<String> privileges;
    private static final ClientLogger LOGGER = new ClientLogger(AccessControlRulesRole.class);

    public String name() {
        return this.name;
    }

    public AccessControlRulesRole withName(String name) {
        this.name = name;
        return this;
    }

    public List<String> privileges() {
        return this.privileges;
    }

    public AccessControlRulesRole withPrivileges(List<String> privileges) {
        this.privileges = privileges;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model AccessControlRulesRole"));
        }
        if (this.privileges() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property privileges in model AccessControlRulesRole"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("privileges", this.privileges, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static AccessControlRulesRole fromJson(JsonReader jsonReader) throws IOException {
        return (AccessControlRulesRole)jsonReader.readObject(reader -> {
            AccessControlRulesRole deserializedAccessControlRulesRole = new AccessControlRulesRole();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedAccessControlRulesRole.name = reader.getString();
                    continue;
                }
                if ("privileges".equals(fieldName)) {
                    List privileges;
                    deserializedAccessControlRulesRole.privileges = privileges = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAccessControlRulesRole;
        });
    }
}

