/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetInner;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineScaleSetListResult
implements JsonSerializable<VirtualMachineScaleSetListResult> {
    private List<VirtualMachineScaleSetInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineScaleSetListResult.class);

    public List<VirtualMachineScaleSetInner> value() {
        return this.value;
    }

    public VirtualMachineScaleSetListResult withValue(List<VirtualMachineScaleSetInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public VirtualMachineScaleSetListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model VirtualMachineScaleSetListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetListResult fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetListResult)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetListResult deserializedVirtualMachineScaleSetListResult = new VirtualMachineScaleSetListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedVirtualMachineScaleSetListResult.value = value = reader.readArray(reader1 -> VirtualMachineScaleSetInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetListResult;
        });
    }
}

