/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.SnapshotUpdateProperties;
import com.azure.resourcemanager.compute.models.DataAccessAuthMode;
import com.azure.resourcemanager.compute.models.Encryption;
import com.azure.resourcemanager.compute.models.EncryptionSettingsCollection;
import com.azure.resourcemanager.compute.models.NetworkAccessPolicy;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.PublicNetworkAccess;
import com.azure.resourcemanager.compute.models.SnapshotAccessState;
import com.azure.resourcemanager.compute.models.SnapshotSku;
import com.azure.resourcemanager.compute.models.SupportedCapabilities;
import java.io.IOException;
import java.util.Map;

public final class SnapshotUpdate
implements JsonSerializable<SnapshotUpdate> {
    private SnapshotUpdateProperties innerProperties;
    private Map<String, String> tags;
    private SnapshotSku sku;

    private SnapshotUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public SnapshotUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public SnapshotSku sku() {
        return this.sku;
    }

    public SnapshotUpdate withSku(SnapshotSku sku) {
        this.sku = sku;
        return this;
    }

    public OperatingSystemTypes osType() {
        return this.innerProperties() == null ? null : this.innerProperties().osType();
    }

    public SnapshotUpdate withOsType(OperatingSystemTypes osType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotUpdateProperties();
        }
        this.innerProperties().withOsType(osType);
        return this;
    }

    public Integer diskSizeGB() {
        return this.innerProperties() == null ? null : this.innerProperties().diskSizeGB();
    }

    public SnapshotUpdate withDiskSizeGB(Integer diskSizeGB) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotUpdateProperties();
        }
        this.innerProperties().withDiskSizeGB(diskSizeGB);
        return this;
    }

    public EncryptionSettingsCollection encryptionSettingsCollection() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionSettingsCollection();
    }

    public SnapshotUpdate withEncryptionSettingsCollection(EncryptionSettingsCollection encryptionSettingsCollection) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotUpdateProperties();
        }
        this.innerProperties().withEncryptionSettingsCollection(encryptionSettingsCollection);
        return this;
    }

    public Encryption encryption() {
        return this.innerProperties() == null ? null : this.innerProperties().encryption();
    }

    public SnapshotUpdate withEncryption(Encryption encryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotUpdateProperties();
        }
        this.innerProperties().withEncryption(encryption);
        return this;
    }

    public NetworkAccessPolicy networkAccessPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().networkAccessPolicy();
    }

    public SnapshotUpdate withNetworkAccessPolicy(NetworkAccessPolicy networkAccessPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotUpdateProperties();
        }
        this.innerProperties().withNetworkAccessPolicy(networkAccessPolicy);
        return this;
    }

    public String diskAccessId() {
        return this.innerProperties() == null ? null : this.innerProperties().diskAccessId();
    }

    public SnapshotUpdate withDiskAccessId(String diskAccessId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotUpdateProperties();
        }
        this.innerProperties().withDiskAccessId(diskAccessId);
        return this;
    }

    public Boolean supportsHibernation() {
        return this.innerProperties() == null ? null : this.innerProperties().supportsHibernation();
    }

    public SnapshotUpdate withSupportsHibernation(Boolean supportsHibernation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotUpdateProperties();
        }
        this.innerProperties().withSupportsHibernation(supportsHibernation);
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public SnapshotUpdate withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotUpdateProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public DataAccessAuthMode dataAccessAuthMode() {
        return this.innerProperties() == null ? null : this.innerProperties().dataAccessAuthMode();
    }

    public SnapshotUpdate withDataAccessAuthMode(DataAccessAuthMode dataAccessAuthMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotUpdateProperties();
        }
        this.innerProperties().withDataAccessAuthMode(dataAccessAuthMode);
        return this;
    }

    public SupportedCapabilities supportedCapabilities() {
        return this.innerProperties() == null ? null : this.innerProperties().supportedCapabilities();
    }

    public SnapshotUpdate withSupportedCapabilities(SupportedCapabilities supportedCapabilities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotUpdateProperties();
        }
        this.innerProperties().withSupportedCapabilities(supportedCapabilities);
        return this;
    }

    public SnapshotAccessState snapshotAccessState() {
        return this.innerProperties() == null ? null : this.innerProperties().snapshotAccessState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        return jsonWriter.writeEndObject();
    }

    public static SnapshotUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (SnapshotUpdate)jsonReader.readObject(reader -> {
            SnapshotUpdate deserializedSnapshotUpdate = new SnapshotUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedSnapshotUpdate.innerProperties = SnapshotUpdateProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedSnapshotUpdate.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedSnapshotUpdate.sku = SnapshotSku.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSnapshotUpdate;
        });
    }
}

