/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.EncryptionType;
import java.io.IOException;

public final class Encryption
implements JsonSerializable<Encryption> {
    private String diskEncryptionSetId;
    private EncryptionType type;

    public String diskEncryptionSetId() {
        return this.diskEncryptionSetId;
    }

    public Encryption withDiskEncryptionSetId(String diskEncryptionSetId) {
        this.diskEncryptionSetId = diskEncryptionSetId;
        return this;
    }

    public EncryptionType type() {
        return this.type;
    }

    public Encryption withType(EncryptionType type) {
        this.type = type;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("diskEncryptionSetId", this.diskEncryptionSetId);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static Encryption fromJson(JsonReader jsonReader) throws IOException {
        return (Encryption)jsonReader.readObject(reader -> {
            Encryption deserializedEncryption = new Encryption();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("diskEncryptionSetId".equals(fieldName)) {
                    deserializedEncryption.diskEncryptionSetId = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedEncryption.type = EncryptionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEncryption;
        });
    }
}

