/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.Architecture;
import com.azure.resourcemanager.compute.models.Disallowed;
import com.azure.resourcemanager.compute.models.GalleryImageFeature;
import com.azure.resourcemanager.compute.models.GalleryImageIdentifier;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.ImagePurchasePlan;
import com.azure.resourcemanager.compute.models.OperatingSystemStateTypes;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.RecommendedMachineConfiguration;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public final class SharedGalleryImageProperties
implements JsonSerializable<SharedGalleryImageProperties> {
    private OperatingSystemTypes osType;
    private OperatingSystemStateTypes osState;
    private OffsetDateTime endOfLifeDate;
    private GalleryImageIdentifier identifier;
    private RecommendedMachineConfiguration recommended;
    private Disallowed disallowed;
    private HyperVGeneration hyperVGeneration;
    private List<GalleryImageFeature> features;
    private ImagePurchasePlan purchasePlan;
    private Architecture architecture;
    private String privacyStatementUri;
    private String eula;
    private Map<String, String> artifactTags;
    private static final ClientLogger LOGGER = new ClientLogger(SharedGalleryImageProperties.class);

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public SharedGalleryImageProperties withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public OperatingSystemStateTypes osState() {
        return this.osState;
    }

    public SharedGalleryImageProperties withOsState(OperatingSystemStateTypes osState) {
        this.osState = osState;
        return this;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    public SharedGalleryImageProperties withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        this.endOfLifeDate = endOfLifeDate;
        return this;
    }

    public GalleryImageIdentifier identifier() {
        return this.identifier;
    }

    public SharedGalleryImageProperties withIdentifier(GalleryImageIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public RecommendedMachineConfiguration recommended() {
        return this.recommended;
    }

    public SharedGalleryImageProperties withRecommended(RecommendedMachineConfiguration recommended) {
        this.recommended = recommended;
        return this;
    }

    public Disallowed disallowed() {
        return this.disallowed;
    }

    public SharedGalleryImageProperties withDisallowed(Disallowed disallowed) {
        this.disallowed = disallowed;
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public SharedGalleryImageProperties withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public List<GalleryImageFeature> features() {
        return this.features;
    }

    public SharedGalleryImageProperties withFeatures(List<GalleryImageFeature> features) {
        this.features = features;
        return this;
    }

    public ImagePurchasePlan purchasePlan() {
        return this.purchasePlan;
    }

    public SharedGalleryImageProperties withPurchasePlan(ImagePurchasePlan purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    public Architecture architecture() {
        return this.architecture;
    }

    public SharedGalleryImageProperties withArchitecture(Architecture architecture) {
        this.architecture = architecture;
        return this;
    }

    public String privacyStatementUri() {
        return this.privacyStatementUri;
    }

    public SharedGalleryImageProperties withPrivacyStatementUri(String privacyStatementUri) {
        this.privacyStatementUri = privacyStatementUri;
        return this;
    }

    public String eula() {
        return this.eula;
    }

    public SharedGalleryImageProperties withEula(String eula) {
        this.eula = eula;
        return this;
    }

    public Map<String, String> artifactTags() {
        return this.artifactTags;
    }

    public SharedGalleryImageProperties withArtifactTags(Map<String, String> artifactTags) {
        this.artifactTags = artifactTags;
        return this;
    }

    public void validate() {
        if (this.osType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property osType in model SharedGalleryImageProperties"));
        }
        if (this.osState() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property osState in model SharedGalleryImageProperties"));
        }
        if (this.identifier() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property identifier in model SharedGalleryImageProperties"));
        }
        this.identifier().validate();
        if (this.recommended() != null) {
            this.recommended().validate();
        }
        if (this.disallowed() != null) {
            this.disallowed().validate();
        }
        if (this.features() != null) {
            this.features().forEach(e -> e.validate());
        }
        if (this.purchasePlan() != null) {
            this.purchasePlan().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeStringField("osState", this.osState == null ? null : this.osState.toString());
        jsonWriter.writeJsonField("identifier", (JsonSerializable)this.identifier);
        jsonWriter.writeStringField("endOfLifeDate", this.endOfLifeDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endOfLifeDate));
        jsonWriter.writeJsonField("recommended", (JsonSerializable)this.recommended);
        jsonWriter.writeJsonField("disallowed", (JsonSerializable)this.disallowed);
        jsonWriter.writeStringField("hyperVGeneration", this.hyperVGeneration == null ? null : this.hyperVGeneration.toString());
        jsonWriter.writeArrayField("features", this.features, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("purchasePlan", (JsonSerializable)this.purchasePlan);
        jsonWriter.writeStringField("architecture", this.architecture == null ? null : this.architecture.toString());
        jsonWriter.writeStringField("privacyStatementUri", this.privacyStatementUri);
        jsonWriter.writeStringField("eula", this.eula);
        jsonWriter.writeMapField("artifactTags", this.artifactTags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static SharedGalleryImageProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SharedGalleryImageProperties)jsonReader.readObject(reader -> {
            SharedGalleryImageProperties deserializedSharedGalleryImageProperties = new SharedGalleryImageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("osType".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.osType = OperatingSystemTypes.fromString(reader.getString());
                    continue;
                }
                if ("osState".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.osState = OperatingSystemStateTypes.fromString(reader.getString());
                    continue;
                }
                if ("identifier".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.identifier = GalleryImageIdentifier.fromJson(reader);
                    continue;
                }
                if ("endOfLifeDate".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.endOfLifeDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("recommended".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.recommended = RecommendedMachineConfiguration.fromJson(reader);
                    continue;
                }
                if ("disallowed".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.disallowed = Disallowed.fromJson(reader);
                    continue;
                }
                if ("hyperVGeneration".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.hyperVGeneration = HyperVGeneration.fromString(reader.getString());
                    continue;
                }
                if ("features".equals(fieldName)) {
                    List features;
                    deserializedSharedGalleryImageProperties.features = features = reader.readArray(reader1 -> GalleryImageFeature.fromJson(reader1));
                    continue;
                }
                if ("purchasePlan".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.purchasePlan = ImagePurchasePlan.fromJson(reader);
                    continue;
                }
                if ("architecture".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.architecture = Architecture.fromString(reader.getString());
                    continue;
                }
                if ("privacyStatementUri".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.privacyStatementUri = reader.getString();
                    continue;
                }
                if ("eula".equals(fieldName)) {
                    deserializedSharedGalleryImageProperties.eula = reader.getString();
                    continue;
                }
                if ("artifactTags".equals(fieldName)) {
                    Map artifactTags;
                    deserializedSharedGalleryImageProperties.artifactTags = artifactTags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSharedGalleryImageProperties;
        });
    }
}

