/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryArtifactPublishingProfileBase;
import com.azure.resourcemanager.compute.models.GalleryTargetExtendedLocation;
import com.azure.resourcemanager.compute.models.ReplicationMode;
import com.azure.resourcemanager.compute.models.StorageAccountType;
import com.azure.resourcemanager.compute.models.TargetRegion;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class GalleryImageVersionPublishingProfile
extends GalleryArtifactPublishingProfileBase {
    private OffsetDateTime publishedDate;

    @Override
    public OffsetDateTime publishedDate() {
        return this.publishedDate;
    }

    @Override
    public GalleryImageVersionPublishingProfile withTargetRegions(List<TargetRegion> targetRegions) {
        super.withTargetRegions(targetRegions);
        return this;
    }

    @Override
    public GalleryImageVersionPublishingProfile withReplicaCount(Integer replicaCount) {
        super.withReplicaCount(replicaCount);
        return this;
    }

    @Override
    public GalleryImageVersionPublishingProfile withExcludeFromLatest(Boolean excludeFromLatest) {
        super.withExcludeFromLatest(excludeFromLatest);
        return this;
    }

    @Override
    public GalleryImageVersionPublishingProfile withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        super.withEndOfLifeDate(endOfLifeDate);
        return this;
    }

    @Override
    public GalleryImageVersionPublishingProfile withStorageAccountType(StorageAccountType storageAccountType) {
        super.withStorageAccountType(storageAccountType);
        return this;
    }

    @Override
    public GalleryImageVersionPublishingProfile withReplicationMode(ReplicationMode replicationMode) {
        super.withReplicationMode(replicationMode);
        return this;
    }

    @Override
    public GalleryImageVersionPublishingProfile withTargetExtendedLocations(List<GalleryTargetExtendedLocation> targetExtendedLocations) {
        super.withTargetExtendedLocations(targetExtendedLocations);
        return this;
    }

    @Override
    public void validate() {
        if (this.targetRegions() != null) {
            this.targetRegions().forEach(e -> e.validate());
        }
        if (this.targetExtendedLocations() != null) {
            this.targetExtendedLocations().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targetRegions", this.targetRegions(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("replicaCount", (Number)this.replicaCount());
        jsonWriter.writeBooleanField("excludeFromLatest", this.excludeFromLatest());
        jsonWriter.writeStringField("endOfLifeDate", this.endOfLifeDate() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endOfLifeDate()));
        jsonWriter.writeStringField("storageAccountType", this.storageAccountType() == null ? null : this.storageAccountType().toString());
        jsonWriter.writeStringField("replicationMode", this.replicationMode() == null ? null : this.replicationMode().toString());
        jsonWriter.writeArrayField("targetExtendedLocations", this.targetExtendedLocations(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static GalleryImageVersionPublishingProfile fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryImageVersionPublishingProfile)jsonReader.readObject(reader -> {
            GalleryImageVersionPublishingProfile deserializedGalleryImageVersionPublishingProfile = new GalleryImageVersionPublishingProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetRegions".equals(fieldName)) {
                    List targetRegions = reader.readArray(reader1 -> TargetRegion.fromJson(reader1));
                    deserializedGalleryImageVersionPublishingProfile.withTargetRegions(targetRegions);
                    continue;
                }
                if ("replicaCount".equals(fieldName)) {
                    deserializedGalleryImageVersionPublishingProfile.withReplicaCount((Integer)reader.getNullable(JsonReader::getInt));
                    continue;
                }
                if ("excludeFromLatest".equals(fieldName)) {
                    deserializedGalleryImageVersionPublishingProfile.withExcludeFromLatest((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("publishedDate".equals(fieldName)) {
                    deserializedGalleryImageVersionPublishingProfile.publishedDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endOfLifeDate".equals(fieldName)) {
                    deserializedGalleryImageVersionPublishingProfile.withEndOfLifeDate((OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString())));
                    continue;
                }
                if ("storageAccountType".equals(fieldName)) {
                    deserializedGalleryImageVersionPublishingProfile.withStorageAccountType(StorageAccountType.fromString(reader.getString()));
                    continue;
                }
                if ("replicationMode".equals(fieldName)) {
                    deserializedGalleryImageVersionPublishingProfile.withReplicationMode(ReplicationMode.fromString(reader.getString()));
                    continue;
                }
                if ("targetExtendedLocations".equals(fieldName)) {
                    List targetExtendedLocations = reader.readArray(reader1 -> GalleryTargetExtendedLocation.fromJson(reader1));
                    deserializedGalleryImageVersionPublishingProfile.withTargetExtendedLocations(targetExtendedLocations);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryImageVersionPublishingProfile;
        });
    }
}

