/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CloudServiceVaultAndSecretReference;
import java.io.IOException;
import java.util.List;

public final class CloudServiceExtensionProperties
implements JsonSerializable<CloudServiceExtensionProperties> {
    private String publisher;
    private String type;
    private String typeHandlerVersion;
    private Boolean autoUpgradeMinorVersion;
    private Object settings;
    private Object protectedSettings;
    private CloudServiceVaultAndSecretReference protectedSettingsFromKeyVault;
    private String forceUpdateTag;
    private String provisioningState;
    private List<String> rolesAppliedTo;

    public String publisher() {
        return this.publisher;
    }

    public CloudServiceExtensionProperties withPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    public String type() {
        return this.type;
    }

    public CloudServiceExtensionProperties withType(String type) {
        this.type = type;
        return this;
    }

    public String typeHandlerVersion() {
        return this.typeHandlerVersion;
    }

    public CloudServiceExtensionProperties withTypeHandlerVersion(String typeHandlerVersion) {
        this.typeHandlerVersion = typeHandlerVersion;
        return this;
    }

    public Boolean autoUpgradeMinorVersion() {
        return this.autoUpgradeMinorVersion;
    }

    public CloudServiceExtensionProperties withAutoUpgradeMinorVersion(Boolean autoUpgradeMinorVersion) {
        this.autoUpgradeMinorVersion = autoUpgradeMinorVersion;
        return this;
    }

    public Object settings() {
        return this.settings;
    }

    public CloudServiceExtensionProperties withSettings(Object settings) {
        this.settings = settings;
        return this;
    }

    public Object protectedSettings() {
        return this.protectedSettings;
    }

    public CloudServiceExtensionProperties withProtectedSettings(Object protectedSettings) {
        this.protectedSettings = protectedSettings;
        return this;
    }

    public CloudServiceVaultAndSecretReference protectedSettingsFromKeyVault() {
        return this.protectedSettingsFromKeyVault;
    }

    public CloudServiceExtensionProperties withProtectedSettingsFromKeyVault(CloudServiceVaultAndSecretReference protectedSettingsFromKeyVault) {
        this.protectedSettingsFromKeyVault = protectedSettingsFromKeyVault;
        return this;
    }

    public String forceUpdateTag() {
        return this.forceUpdateTag;
    }

    public CloudServiceExtensionProperties withForceUpdateTag(String forceUpdateTag) {
        this.forceUpdateTag = forceUpdateTag;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public List<String> rolesAppliedTo() {
        return this.rolesAppliedTo;
    }

    public CloudServiceExtensionProperties withRolesAppliedTo(List<String> rolesAppliedTo) {
        this.rolesAppliedTo = rolesAppliedTo;
        return this;
    }

    public void validate() {
        if (this.protectedSettingsFromKeyVault() != null) {
            this.protectedSettingsFromKeyVault().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publisher", this.publisher);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("typeHandlerVersion", this.typeHandlerVersion);
        jsonWriter.writeBooleanField("autoUpgradeMinorVersion", this.autoUpgradeMinorVersion);
        jsonWriter.writeUntypedField("settings", this.settings);
        jsonWriter.writeUntypedField("protectedSettings", this.protectedSettings);
        jsonWriter.writeJsonField("protectedSettingsFromKeyVault", (JsonSerializable)this.protectedSettingsFromKeyVault);
        jsonWriter.writeStringField("forceUpdateTag", this.forceUpdateTag);
        jsonWriter.writeArrayField("rolesAppliedTo", this.rolesAppliedTo, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CloudServiceExtensionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (CloudServiceExtensionProperties)jsonReader.readObject(reader -> {
            CloudServiceExtensionProperties deserializedCloudServiceExtensionProperties = new CloudServiceExtensionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("publisher".equals(fieldName)) {
                    deserializedCloudServiceExtensionProperties.publisher = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCloudServiceExtensionProperties.type = reader.getString();
                    continue;
                }
                if ("typeHandlerVersion".equals(fieldName)) {
                    deserializedCloudServiceExtensionProperties.typeHandlerVersion = reader.getString();
                    continue;
                }
                if ("autoUpgradeMinorVersion".equals(fieldName)) {
                    deserializedCloudServiceExtensionProperties.autoUpgradeMinorVersion = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("settings".equals(fieldName)) {
                    deserializedCloudServiceExtensionProperties.settings = reader.readUntyped();
                    continue;
                }
                if ("protectedSettings".equals(fieldName)) {
                    deserializedCloudServiceExtensionProperties.protectedSettings = reader.readUntyped();
                    continue;
                }
                if ("protectedSettingsFromKeyVault".equals(fieldName)) {
                    deserializedCloudServiceExtensionProperties.protectedSettingsFromKeyVault = CloudServiceVaultAndSecretReference.fromJson(reader);
                    continue;
                }
                if ("forceUpdateTag".equals(fieldName)) {
                    deserializedCloudServiceExtensionProperties.forceUpdateTag = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedCloudServiceExtensionProperties.provisioningState = reader.getString();
                    continue;
                }
                if ("rolesAppliedTo".equals(fieldName)) {
                    List rolesAppliedTo;
                    deserializedCloudServiceExtensionProperties.rolesAppliedTo = rolesAppliedTo = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudServiceExtensionProperties;
        });
    }
}

