/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetProperties;
import com.azure.resourcemanager.compute.models.AdditionalCapabilities;
import com.azure.resourcemanager.compute.models.AutomaticRepairsPolicy;
import com.azure.resourcemanager.compute.models.ExtendedLocation;
import com.azure.resourcemanager.compute.models.OrchestrationMode;
import com.azure.resourcemanager.compute.models.Plan;
import com.azure.resourcemanager.compute.models.PriorityMixPolicy;
import com.azure.resourcemanager.compute.models.ResiliencyPolicy;
import com.azure.resourcemanager.compute.models.ScaleInPolicy;
import com.azure.resourcemanager.compute.models.ScheduledEventsPolicy;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.SkuProfile;
import com.azure.resourcemanager.compute.models.SpotRestorePolicy;
import com.azure.resourcemanager.compute.models.UpgradePolicy;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetIdentity;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMProfile;
import com.azure.resourcemanager.compute.models.ZonalPlatformFaultDomainAlignMode;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class VirtualMachineScaleSetInner
extends Resource {
    private Sku sku;
    private Plan plan;
    private VirtualMachineScaleSetProperties innerProperties;
    private VirtualMachineScaleSetIdentity identity;
    private List<String> zones;
    private ExtendedLocation extendedLocation;
    private String etag;
    private String type;
    private String name;
    private String id;

    public Sku sku() {
        return this.sku;
    }

    public VirtualMachineScaleSetInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Plan plan() {
        return this.plan;
    }

    public VirtualMachineScaleSetInner withPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    private VirtualMachineScaleSetProperties innerProperties() {
        return this.innerProperties;
    }

    public VirtualMachineScaleSetIdentity identity() {
        return this.identity;
    }

    public VirtualMachineScaleSetInner withIdentity(VirtualMachineScaleSetIdentity identity) {
        this.identity = identity;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public VirtualMachineScaleSetInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public VirtualMachineScaleSetInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public VirtualMachineScaleSetInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualMachineScaleSetInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public UpgradePolicy upgradePolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().upgradePolicy();
    }

    public VirtualMachineScaleSetInner withUpgradePolicy(UpgradePolicy upgradePolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withUpgradePolicy(upgradePolicy);
        return this;
    }

    public ScheduledEventsPolicy scheduledEventsPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().scheduledEventsPolicy();
    }

    public VirtualMachineScaleSetInner withScheduledEventsPolicy(ScheduledEventsPolicy scheduledEventsPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withScheduledEventsPolicy(scheduledEventsPolicy);
        return this;
    }

    public AutomaticRepairsPolicy automaticRepairsPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().automaticRepairsPolicy();
    }

    public VirtualMachineScaleSetInner withAutomaticRepairsPolicy(AutomaticRepairsPolicy automaticRepairsPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withAutomaticRepairsPolicy(automaticRepairsPolicy);
        return this;
    }

    public VirtualMachineScaleSetVMProfile virtualMachineProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualMachineProfile();
    }

    public VirtualMachineScaleSetInner withVirtualMachineProfile(VirtualMachineScaleSetVMProfile virtualMachineProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withVirtualMachineProfile(virtualMachineProfile);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Boolean overprovision() {
        return this.innerProperties() == null ? null : this.innerProperties().overprovision();
    }

    public VirtualMachineScaleSetInner withOverprovision(Boolean overprovision) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withOverprovision(overprovision);
        return this;
    }

    public Boolean doNotRunExtensionsOnOverprovisionedVMs() {
        return this.innerProperties() == null ? null : this.innerProperties().doNotRunExtensionsOnOverprovisionedVMs();
    }

    public VirtualMachineScaleSetInner withDoNotRunExtensionsOnOverprovisionedVMs(Boolean doNotRunExtensionsOnOverprovisionedVMs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withDoNotRunExtensionsOnOverprovisionedVMs(doNotRunExtensionsOnOverprovisionedVMs);
        return this;
    }

    public String uniqueId() {
        return this.innerProperties() == null ? null : this.innerProperties().uniqueId();
    }

    public Boolean singlePlacementGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().singlePlacementGroup();
    }

    public VirtualMachineScaleSetInner withSinglePlacementGroup(Boolean singlePlacementGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withSinglePlacementGroup(singlePlacementGroup);
        return this;
    }

    public Boolean zoneBalance() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneBalance();
    }

    public VirtualMachineScaleSetInner withZoneBalance(Boolean zoneBalance) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withZoneBalance(zoneBalance);
        return this;
    }

    public Integer platformFaultDomainCount() {
        return this.innerProperties() == null ? null : this.innerProperties().platformFaultDomainCount();
    }

    public VirtualMachineScaleSetInner withPlatformFaultDomainCount(Integer platformFaultDomainCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withPlatformFaultDomainCount(platformFaultDomainCount);
        return this;
    }

    public SubResource proximityPlacementGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().proximityPlacementGroup();
    }

    public VirtualMachineScaleSetInner withProximityPlacementGroup(SubResource proximityPlacementGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withProximityPlacementGroup(proximityPlacementGroup);
        return this;
    }

    public SubResource hostGroup() {
        return this.innerProperties() == null ? null : this.innerProperties().hostGroup();
    }

    public VirtualMachineScaleSetInner withHostGroup(SubResource hostGroup) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withHostGroup(hostGroup);
        return this;
    }

    public AdditionalCapabilities additionalCapabilities() {
        return this.innerProperties() == null ? null : this.innerProperties().additionalCapabilities();
    }

    public VirtualMachineScaleSetInner withAdditionalCapabilities(AdditionalCapabilities additionalCapabilities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withAdditionalCapabilities(additionalCapabilities);
        return this;
    }

    public ScaleInPolicy scaleInPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().scaleInPolicy();
    }

    public VirtualMachineScaleSetInner withScaleInPolicy(ScaleInPolicy scaleInPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withScaleInPolicy(scaleInPolicy);
        return this;
    }

    public OrchestrationMode orchestrationMode() {
        return this.innerProperties() == null ? null : this.innerProperties().orchestrationMode();
    }

    public VirtualMachineScaleSetInner withOrchestrationMode(OrchestrationMode orchestrationMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withOrchestrationMode(orchestrationMode);
        return this;
    }

    public SpotRestorePolicy spotRestorePolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().spotRestorePolicy();
    }

    public VirtualMachineScaleSetInner withSpotRestorePolicy(SpotRestorePolicy spotRestorePolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withSpotRestorePolicy(spotRestorePolicy);
        return this;
    }

    public PriorityMixPolicy priorityMixPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().priorityMixPolicy();
    }

    public VirtualMachineScaleSetInner withPriorityMixPolicy(PriorityMixPolicy priorityMixPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withPriorityMixPolicy(priorityMixPolicy);
        return this;
    }

    public OffsetDateTime timeCreated() {
        return this.innerProperties() == null ? null : this.innerProperties().timeCreated();
    }

    public Boolean constrainedMaximumCapacity() {
        return this.innerProperties() == null ? null : this.innerProperties().constrainedMaximumCapacity();
    }

    public VirtualMachineScaleSetInner withConstrainedMaximumCapacity(Boolean constrainedMaximumCapacity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withConstrainedMaximumCapacity(constrainedMaximumCapacity);
        return this;
    }

    public ResiliencyPolicy resiliencyPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().resiliencyPolicy();
    }

    public VirtualMachineScaleSetInner withResiliencyPolicy(ResiliencyPolicy resiliencyPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withResiliencyPolicy(resiliencyPolicy);
        return this;
    }

    public ZonalPlatformFaultDomainAlignMode zonalPlatformFaultDomainAlignMode() {
        return this.innerProperties() == null ? null : this.innerProperties().zonalPlatformFaultDomainAlignMode();
    }

    public VirtualMachineScaleSetInner withZonalPlatformFaultDomainAlignMode(ZonalPlatformFaultDomainAlignMode zonalPlatformFaultDomainAlignMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withZonalPlatformFaultDomainAlignMode(zonalPlatformFaultDomainAlignMode);
        return this;
    }

    public SkuProfile skuProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().skuProfile();
    }

    public VirtualMachineScaleSetInner withSkuProfile(SkuProfile skuProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetProperties();
        }
        this.innerProperties().withSkuProfile(skuProfile);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.plan() != null) {
            this.plan().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("plan", (JsonSerializable)this.plan);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetInner fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetInner)((Object)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetInner deserializedVirtualMachineScaleSetInner = new VirtualMachineScaleSetInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVirtualMachineScaleSetInner.withTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("plan".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetInner.plan = Plan.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetInner.innerProperties = VirtualMachineScaleSetProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetInner.identity = VirtualMachineScaleSetIdentity.fromJson(reader);
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedVirtualMachineScaleSetInner.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetInner.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetInner;
        }));
    }
}

