/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.SshPublicKeyResourceProperties;
import com.azure.resourcemanager.compute.models.UpdateResource;
import java.io.IOException;
import java.util.Map;

public final class SshPublicKeyUpdateResource
extends UpdateResource {
    private SshPublicKeyResourceProperties innerProperties;

    private SshPublicKeyResourceProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public SshPublicKeyUpdateResource withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String publicKey() {
        return this.innerProperties() == null ? null : this.innerProperties().publicKey();
    }

    public SshPublicKeyUpdateResource withPublicKey(String publicKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SshPublicKeyResourceProperties();
        }
        this.innerProperties().withPublicKey(publicKey);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SshPublicKeyUpdateResource fromJson(JsonReader jsonReader) throws IOException {
        return (SshPublicKeyUpdateResource)jsonReader.readObject(reader -> {
            SshPublicKeyUpdateResource deserializedSshPublicKeyUpdateResource = new SshPublicKeyUpdateResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSshPublicKeyUpdateResource.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSshPublicKeyUpdateResource.innerProperties = SshPublicKeyResourceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSshPublicKeyUpdateResource;
        });
    }
}

