/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.RoleInstanceInner;
import java.io.IOException;
import java.util.List;

public final class RoleInstanceListResult
implements JsonSerializable<RoleInstanceListResult> {
    private List<RoleInstanceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(RoleInstanceListResult.class);

    public List<RoleInstanceInner> value() {
        return this.value;
    }

    public RoleInstanceListResult withValue(List<RoleInstanceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public RoleInstanceListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model RoleInstanceListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static RoleInstanceListResult fromJson(JsonReader jsonReader) throws IOException {
        return (RoleInstanceListResult)jsonReader.readObject(reader -> {
            RoleInstanceListResult deserializedRoleInstanceListResult = new RoleInstanceListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedRoleInstanceListResult.value = value = reader.readArray(reader1 -> RoleInstanceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedRoleInstanceListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoleInstanceListResult;
        });
    }
}

