/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import java.io.IOException;

public class RunCommandDocumentBaseInner
implements JsonSerializable<RunCommandDocumentBaseInner> {
    private String schema;
    private String id;
    private OperatingSystemTypes osType;
    private String label;
    private String description;
    private static final ClientLogger LOGGER = new ClientLogger(RunCommandDocumentBaseInner.class);

    public String schema() {
        return this.schema;
    }

    public RunCommandDocumentBaseInner withSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public String id() {
        return this.id;
    }

    public RunCommandDocumentBaseInner withId(String id) {
        this.id = id;
        return this;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public RunCommandDocumentBaseInner withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public String label() {
        return this.label;
    }

    public RunCommandDocumentBaseInner withLabel(String label) {
        this.label = label;
        return this;
    }

    public String description() {
        return this.description;
    }

    public RunCommandDocumentBaseInner withDescription(String description) {
        this.description = description;
        return this;
    }

    public void validate() {
        if (this.schema() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property schema in model RunCommandDocumentBaseInner"));
        }
        if (this.id() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property id in model RunCommandDocumentBaseInner"));
        }
        if (this.osType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property osType in model RunCommandDocumentBaseInner"));
        }
        if (this.label() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property label in model RunCommandDocumentBaseInner"));
        }
        if (this.description() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property description in model RunCommandDocumentBaseInner"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("$schema", this.schema);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeStringField("label", this.label);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static RunCommandDocumentBaseInner fromJson(JsonReader jsonReader) throws IOException {
        return (RunCommandDocumentBaseInner)jsonReader.readObject(reader -> {
            RunCommandDocumentBaseInner deserializedRunCommandDocumentBaseInner = new RunCommandDocumentBaseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("$schema".equals(fieldName)) {
                    deserializedRunCommandDocumentBaseInner.schema = reader.getString();
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedRunCommandDocumentBaseInner.id = reader.getString();
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    deserializedRunCommandDocumentBaseInner.osType = OperatingSystemTypes.fromString(reader.getString());
                    continue;
                }
                if ("label".equals(fieldName)) {
                    deserializedRunCommandDocumentBaseInner.label = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedRunCommandDocumentBaseInner.description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRunCommandDocumentBaseInner;
        });
    }
}

