/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.Region;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.models.GalleryImageVersionInner;
import com.azure.resourcemanager.compute.models.GalleryImageVersionPublishingProfile;
import com.azure.resourcemanager.compute.models.GalleryImageVersionStorageProfile;
import com.azure.resourcemanager.compute.models.ReplicationStatus;
import com.azure.resourcemanager.compute.models.TargetRegion;
import com.azure.resourcemanager.compute.models.VirtualMachine;
import com.azure.resourcemanager.compute.models.VirtualMachineCustomImage;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasManager;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public interface GalleryImageVersion
extends HasInnerModel<GalleryImageVersionInner>,
Indexable,
Refreshable<GalleryImageVersion>,
Updatable<Update>,
HasManager<ComputeManager> {
    public String id();

    public String location();

    public String name();

    public String provisioningState();

    public GalleryImageVersionPublishingProfile publishingProfile();

    public List<TargetRegion> availableRegions();

    public OffsetDateTime endOfLifeDate();

    public Boolean isExcludedFromLatest();

    public ReplicationStatus replicationStatus();

    public GalleryImageVersionStorageProfile storageProfile();

    public Map<String, String> tags();

    public String type();

    public static interface UpdateStages {

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }

        public static interface WithExcludeFromLatest {
            public Update withExcludedFromLatest();

            public Update withoutExcludedFromLatest();
        }

        public static interface WithEndOfLifeDate {
            public Update withEndOfLifeDate(OffsetDateTime var1);
        }

        public static interface WithAvailableRegion {
            public Update withRegionAvailability(Region var1, int var2);

            public Update withRegionAvailability(List<TargetRegion> var1);

            public Update withoutRegionAvailability(Region var1);
        }
    }

    public static interface Update
    extends Appliable<GalleryImageVersion>,
    UpdateStages.WithAvailableRegion,
    UpdateStages.WithEndOfLifeDate,
    UpdateStages.WithExcludeFromLatest,
    UpdateStages.WithTags {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<GalleryImageVersion>,
        WithAvailableRegion,
        WithEndOfLifeDate,
        WithExcludeFromLatest,
        WithTags {
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithExcludeFromLatest {
            public WithCreate withExcludedFromLatest();
        }

        public static interface WithEndOfLifeDate {
            public WithCreate withEndOfLifeDate(OffsetDateTime var1);
        }

        public static interface WithAvailableRegion {
            public WithCreate withRegionAvailability(Region var1, int var2);

            public WithCreate withRegionAvailability(List<TargetRegion> var1);
        }

        public static interface WithSource {
            public WithCreate withSourceCustomImage(String var1);

            public WithCreate withSourceCustomImage(VirtualMachineCustomImage var1);

            public WithCreate withSourceVirtualMachine(String var1);

            public WithCreate withSourceVirtualMachine(VirtualMachine var1);
        }

        public static interface WithLocation {
            public WithSource withLocation(String var1);

            public WithSource withLocation(Region var1);
        }

        public static interface WithImage {
            public WithLocation withExistingImage(String var1, String var2, String var3);
        }

        public static interface Blank
        extends WithImage {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithImage,
    DefinitionStages.WithLocation,
    DefinitionStages.WithSource,
    DefinitionStages.WithCreate {
    }
}

