/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryDiskImageSource;
import com.azure.resourcemanager.compute.models.HostCaching;
import java.io.IOException;

public class GalleryDiskImage
implements JsonSerializable<GalleryDiskImage> {
    private Integer sizeInGB;
    private HostCaching hostCaching;
    private GalleryDiskImageSource source;

    public Integer sizeInGB() {
        return this.sizeInGB;
    }

    GalleryDiskImage withSizeInGB(Integer sizeInGB) {
        this.sizeInGB = sizeInGB;
        return this;
    }

    public HostCaching hostCaching() {
        return this.hostCaching;
    }

    public GalleryDiskImage withHostCaching(HostCaching hostCaching) {
        this.hostCaching = hostCaching;
        return this;
    }

    public GalleryDiskImageSource source() {
        return this.source;
    }

    public GalleryDiskImage withSource(GalleryDiskImageSource source) {
        this.source = source;
        return this;
    }

    public void validate() {
        if (this.source() != null) {
            this.source().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("hostCaching", this.hostCaching == null ? null : this.hostCaching.toString());
        jsonWriter.writeJsonField("source", (JsonSerializable)this.source);
        return jsonWriter.writeEndObject();
    }

    public static GalleryDiskImage fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryDiskImage)jsonReader.readObject(reader -> {
            GalleryDiskImage deserializedGalleryDiskImage = new GalleryDiskImage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sizeInGB".equals(fieldName)) {
                    deserializedGalleryDiskImage.sizeInGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("hostCaching".equals(fieldName)) {
                    deserializedGalleryDiskImage.hostCaching = HostCaching.fromString(reader.getString());
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedGalleryDiskImage.source = GalleryDiskImageSource.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryDiskImage;
        });
    }
}

