/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.CapacityReservationGroupInner;
import java.io.IOException;
import java.util.List;

public final class CapacityReservationGroupListResult
implements JsonSerializable<CapacityReservationGroupListResult> {
    private List<CapacityReservationGroupInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(CapacityReservationGroupListResult.class);

    public List<CapacityReservationGroupInner> value() {
        return this.value;
    }

    public CapacityReservationGroupListResult withValue(List<CapacityReservationGroupInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public CapacityReservationGroupListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model CapacityReservationGroupListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static CapacityReservationGroupListResult fromJson(JsonReader jsonReader) throws IOException {
        return (CapacityReservationGroupListResult)jsonReader.readObject(reader -> {
            CapacityReservationGroupListResult deserializedCapacityReservationGroupListResult = new CapacityReservationGroupListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedCapacityReservationGroupListResult.value = value = reader.readArray(reader1 -> CapacityReservationGroupInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedCapacityReservationGroupListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCapacityReservationGroupListResult;
        });
    }
}

