/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineExtensionInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetVMInstanceViewInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetVMPropertiesInner;
import com.azure.resourcemanager.compute.models.AdditionalCapabilities;
import com.azure.resourcemanager.compute.models.DiagnosticsProfile;
import com.azure.resourcemanager.compute.models.HardwareProfile;
import com.azure.resourcemanager.compute.models.NetworkProfile;
import com.azure.resourcemanager.compute.models.OSProfile;
import com.azure.resourcemanager.compute.models.Plan;
import com.azure.resourcemanager.compute.models.ResilientVMDeletionStatus;
import com.azure.resourcemanager.compute.models.SecurityProfile;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.StorageProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineIdentity;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMNetworkProfileConfiguration;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMProtectionPolicy;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class VirtualMachineScaleSetVMInner
extends Resource {
    private String instanceId;
    private Sku sku;
    private VirtualMachineScaleSetVMPropertiesInner innerProperties;
    private Plan plan;
    private List<VirtualMachineExtensionInner> resources;
    private List<String> zones;
    private VirtualMachineIdentity identity;
    private String etag;
    private String type;
    private String name;
    private String id;

    public String instanceId() {
        return this.instanceId;
    }

    public Sku sku() {
        return this.sku;
    }

    private VirtualMachineScaleSetVMPropertiesInner innerProperties() {
        return this.innerProperties;
    }

    public Plan plan() {
        return this.plan;
    }

    public VirtualMachineScaleSetVMInner withPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    public List<VirtualMachineExtensionInner> resources() {
        return this.resources;
    }

    public List<String> zones() {
        return this.zones;
    }

    public VirtualMachineIdentity identity() {
        return this.identity;
    }

    public VirtualMachineScaleSetVMInner withIdentity(VirtualMachineIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public VirtualMachineScaleSetVMInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualMachineScaleSetVMInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Boolean latestModelApplied() {
        return this.innerProperties() == null ? null : this.innerProperties().latestModelApplied();
    }

    public String vmId() {
        return this.innerProperties() == null ? null : this.innerProperties().vmId();
    }

    public VirtualMachineScaleSetVMInstanceViewInner instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    public HardwareProfile hardwareProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().hardwareProfile();
    }

    public VirtualMachineScaleSetVMInner withHardwareProfile(HardwareProfile hardwareProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withHardwareProfile(hardwareProfile);
        return this;
    }

    public ResilientVMDeletionStatus resilientVMDeletionStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().resilientVMDeletionStatus();
    }

    public VirtualMachineScaleSetVMInner withResilientVMDeletionStatus(ResilientVMDeletionStatus resilientVMDeletionStatus) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withResilientVMDeletionStatus(resilientVMDeletionStatus);
        return this;
    }

    public StorageProfile storageProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().storageProfile();
    }

    public VirtualMachineScaleSetVMInner withStorageProfile(StorageProfile storageProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withStorageProfile(storageProfile);
        return this;
    }

    public AdditionalCapabilities additionalCapabilities() {
        return this.innerProperties() == null ? null : this.innerProperties().additionalCapabilities();
    }

    public VirtualMachineScaleSetVMInner withAdditionalCapabilities(AdditionalCapabilities additionalCapabilities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withAdditionalCapabilities(additionalCapabilities);
        return this;
    }

    public OSProfile osProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().osProfile();
    }

    public VirtualMachineScaleSetVMInner withOsProfile(OSProfile osProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withOsProfile(osProfile);
        return this;
    }

    public SecurityProfile securityProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().securityProfile();
    }

    public VirtualMachineScaleSetVMInner withSecurityProfile(SecurityProfile securityProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withSecurityProfile(securityProfile);
        return this;
    }

    public NetworkProfile networkProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().networkProfile();
    }

    public VirtualMachineScaleSetVMInner withNetworkProfile(NetworkProfile networkProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withNetworkProfile(networkProfile);
        return this;
    }

    public VirtualMachineScaleSetVMNetworkProfileConfiguration networkProfileConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().networkProfileConfiguration();
    }

    public VirtualMachineScaleSetVMInner withNetworkProfileConfiguration(VirtualMachineScaleSetVMNetworkProfileConfiguration networkProfileConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withNetworkProfileConfiguration(networkProfileConfiguration);
        return this;
    }

    public DiagnosticsProfile diagnosticsProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().diagnosticsProfile();
    }

    public VirtualMachineScaleSetVMInner withDiagnosticsProfile(DiagnosticsProfile diagnosticsProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withDiagnosticsProfile(diagnosticsProfile);
        return this;
    }

    public SubResource availabilitySet() {
        return this.innerProperties() == null ? null : this.innerProperties().availabilitySet();
    }

    public VirtualMachineScaleSetVMInner withAvailabilitySet(SubResource availabilitySet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withAvailabilitySet(availabilitySet);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    public VirtualMachineScaleSetVMInner withLicenseType(String licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    public String modelDefinitionApplied() {
        return this.innerProperties() == null ? null : this.innerProperties().modelDefinitionApplied();
    }

    public VirtualMachineScaleSetVMProtectionPolicy protectionPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().protectionPolicy();
    }

    public VirtualMachineScaleSetVMInner withProtectionPolicy(VirtualMachineScaleSetVMProtectionPolicy protectionPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withProtectionPolicy(protectionPolicy);
        return this;
    }

    public String userData() {
        return this.innerProperties() == null ? null : this.innerProperties().userData();
    }

    public VirtualMachineScaleSetVMInner withUserData(String userData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withUserData(userData);
        return this;
    }

    public OffsetDateTime timeCreated() {
        return this.innerProperties() == null ? null : this.innerProperties().timeCreated();
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.plan() != null) {
            this.plan().validate();
        }
        if (this.resources() != null) {
            this.resources().forEach(e -> e.validate());
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("plan", (JsonSerializable)this.plan);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetVMInner fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetVMInner)((Object)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetVMInner deserializedVirtualMachineScaleSetVMInner = new VirtualMachineScaleSetVMInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVirtualMachineScaleSetVMInner.withTags(tags);
                    continue;
                }
                if ("instanceId".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInner.instanceId = reader.getString();
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInner.innerProperties = VirtualMachineScaleSetVMPropertiesInner.fromJson(reader);
                    continue;
                }
                if ("plan".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInner.plan = Plan.fromJson(reader);
                    continue;
                }
                if ("resources".equals(fieldName)) {
                    List resources;
                    deserializedVirtualMachineScaleSetVMInner.resources = resources = reader.readArray(reader1 -> VirtualMachineExtensionInner.fromJson(reader1));
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedVirtualMachineScaleSetVMInner.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInner.identity = VirtualMachineIdentity.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMInner.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetVMInner;
        }));
    }
}

