/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.ArchitectureTypes;
import com.azure.resourcemanager.compute.models.AutomaticOSUpgradeProperties;
import com.azure.resourcemanager.compute.models.DataDiskImage;
import com.azure.resourcemanager.compute.models.DisallowedConfiguration;
import com.azure.resourcemanager.compute.models.HyperVGenerationTypes;
import com.azure.resourcemanager.compute.models.ImageDeprecationStatus;
import com.azure.resourcemanager.compute.models.OSDiskImage;
import com.azure.resourcemanager.compute.models.PurchasePlan;
import com.azure.resourcemanager.compute.models.VirtualMachineImageFeature;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineImageProperties
implements JsonSerializable<VirtualMachineImageProperties> {
    private PurchasePlan plan;
    private OSDiskImage osDiskImage;
    private List<DataDiskImage> dataDiskImages;
    private AutomaticOSUpgradeProperties automaticOSUpgradeProperties;
    private HyperVGenerationTypes hyperVGeneration;
    private DisallowedConfiguration disallowed;
    private List<VirtualMachineImageFeature> features;
    private ArchitectureTypes architecture;
    private ImageDeprecationStatus imageDeprecationStatus;

    public PurchasePlan plan() {
        return this.plan;
    }

    public VirtualMachineImageProperties withPlan(PurchasePlan plan) {
        this.plan = plan;
        return this;
    }

    public OSDiskImage osDiskImage() {
        return this.osDiskImage;
    }

    public VirtualMachineImageProperties withOsDiskImage(OSDiskImage osDiskImage) {
        this.osDiskImage = osDiskImage;
        return this;
    }

    public List<DataDiskImage> dataDiskImages() {
        return this.dataDiskImages;
    }

    public VirtualMachineImageProperties withDataDiskImages(List<DataDiskImage> dataDiskImages) {
        this.dataDiskImages = dataDiskImages;
        return this;
    }

    public AutomaticOSUpgradeProperties automaticOSUpgradeProperties() {
        return this.automaticOSUpgradeProperties;
    }

    public VirtualMachineImageProperties withAutomaticOSUpgradeProperties(AutomaticOSUpgradeProperties automaticOSUpgradeProperties) {
        this.automaticOSUpgradeProperties = automaticOSUpgradeProperties;
        return this;
    }

    public HyperVGenerationTypes hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public VirtualMachineImageProperties withHyperVGeneration(HyperVGenerationTypes hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public DisallowedConfiguration disallowed() {
        return this.disallowed;
    }

    public VirtualMachineImageProperties withDisallowed(DisallowedConfiguration disallowed) {
        this.disallowed = disallowed;
        return this;
    }

    public List<VirtualMachineImageFeature> features() {
        return this.features;
    }

    public VirtualMachineImageProperties withFeatures(List<VirtualMachineImageFeature> features) {
        this.features = features;
        return this;
    }

    public ArchitectureTypes architecture() {
        return this.architecture;
    }

    public VirtualMachineImageProperties withArchitecture(ArchitectureTypes architecture) {
        this.architecture = architecture;
        return this;
    }

    public ImageDeprecationStatus imageDeprecationStatus() {
        return this.imageDeprecationStatus;
    }

    public VirtualMachineImageProperties withImageDeprecationStatus(ImageDeprecationStatus imageDeprecationStatus) {
        this.imageDeprecationStatus = imageDeprecationStatus;
        return this;
    }

    public void validate() {
        if (this.plan() != null) {
            this.plan().validate();
        }
        if (this.osDiskImage() != null) {
            this.osDiskImage().validate();
        }
        if (this.dataDiskImages() != null) {
            this.dataDiskImages().forEach(e -> e.validate());
        }
        if (this.automaticOSUpgradeProperties() != null) {
            this.automaticOSUpgradeProperties().validate();
        }
        if (this.disallowed() != null) {
            this.disallowed().validate();
        }
        if (this.features() != null) {
            this.features().forEach(e -> e.validate());
        }
        if (this.imageDeprecationStatus() != null) {
            this.imageDeprecationStatus().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("plan", (JsonSerializable)this.plan);
        jsonWriter.writeJsonField("osDiskImage", (JsonSerializable)this.osDiskImage);
        jsonWriter.writeArrayField("dataDiskImages", this.dataDiskImages, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("automaticOSUpgradeProperties", (JsonSerializable)this.automaticOSUpgradeProperties);
        jsonWriter.writeStringField("hyperVGeneration", this.hyperVGeneration == null ? null : this.hyperVGeneration.toString());
        jsonWriter.writeJsonField("disallowed", (JsonSerializable)this.disallowed);
        jsonWriter.writeArrayField("features", this.features, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("architecture", this.architecture == null ? null : this.architecture.toString());
        jsonWriter.writeJsonField("imageDeprecationStatus", (JsonSerializable)this.imageDeprecationStatus);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineImageProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineImageProperties)jsonReader.readObject(reader -> {
            VirtualMachineImageProperties deserializedVirtualMachineImageProperties = new VirtualMachineImageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("plan".equals(fieldName)) {
                    deserializedVirtualMachineImageProperties.plan = PurchasePlan.fromJson(reader);
                    continue;
                }
                if ("osDiskImage".equals(fieldName)) {
                    deserializedVirtualMachineImageProperties.osDiskImage = OSDiskImage.fromJson(reader);
                    continue;
                }
                if ("dataDiskImages".equals(fieldName)) {
                    List dataDiskImages;
                    deserializedVirtualMachineImageProperties.dataDiskImages = dataDiskImages = reader.readArray(reader1 -> DataDiskImage.fromJson(reader1));
                    continue;
                }
                if ("automaticOSUpgradeProperties".equals(fieldName)) {
                    deserializedVirtualMachineImageProperties.automaticOSUpgradeProperties = AutomaticOSUpgradeProperties.fromJson(reader);
                    continue;
                }
                if ("hyperVGeneration".equals(fieldName)) {
                    deserializedVirtualMachineImageProperties.hyperVGeneration = HyperVGenerationTypes.fromString(reader.getString());
                    continue;
                }
                if ("disallowed".equals(fieldName)) {
                    deserializedVirtualMachineImageProperties.disallowed = DisallowedConfiguration.fromJson(reader);
                    continue;
                }
                if ("features".equals(fieldName)) {
                    List features;
                    deserializedVirtualMachineImageProperties.features = features = reader.readArray(reader1 -> VirtualMachineImageFeature.fromJson(reader1));
                    continue;
                }
                if ("architecture".equals(fieldName)) {
                    deserializedVirtualMachineImageProperties.architecture = ArchitectureTypes.fromString(reader.getString());
                    continue;
                }
                if ("imageDeprecationStatus".equals(fieldName)) {
                    deserializedVirtualMachineImageProperties.imageDeprecationStatus = ImageDeprecationStatus.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineImageProperties;
        });
    }
}

