/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineInner;
import java.io.IOException;
import java.util.List;

public final class VirtualMachineListResult
implements JsonSerializable<VirtualMachineListResult> {
    private List<VirtualMachineInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineListResult.class);

    public List<VirtualMachineInner> value() {
        return this.value;
    }

    public VirtualMachineListResult withValue(List<VirtualMachineInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public VirtualMachineListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model VirtualMachineListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineListResult fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineListResult)jsonReader.readObject(reader -> {
            VirtualMachineListResult deserializedVirtualMachineListResult = new VirtualMachineListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedVirtualMachineListResult.value = value = reader.readArray(reader1 -> VirtualMachineInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedVirtualMachineListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineListResult;
        });
    }
}

