/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.RunCommandInputParameter;
import java.io.IOException;
import java.util.List;

public final class RunCommandInput
implements JsonSerializable<RunCommandInput> {
    private String commandId;
    private List<String> script;
    private List<RunCommandInputParameter> parameters;
    private static final ClientLogger LOGGER = new ClientLogger(RunCommandInput.class);

    public String commandId() {
        return this.commandId;
    }

    public RunCommandInput withCommandId(String commandId) {
        this.commandId = commandId;
        return this;
    }

    public List<String> script() {
        return this.script;
    }

    public RunCommandInput withScript(List<String> script) {
        this.script = script;
        return this;
    }

    public List<RunCommandInputParameter> parameters() {
        return this.parameters;
    }

    public RunCommandInput withParameters(List<RunCommandInputParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.commandId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property commandId in model RunCommandInput"));
        }
        if (this.parameters() != null) {
            this.parameters().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("commandId", this.commandId);
        jsonWriter.writeArrayField("script", this.script, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RunCommandInput fromJson(JsonReader jsonReader) throws IOException {
        return (RunCommandInput)jsonReader.readObject(reader -> {
            RunCommandInput deserializedRunCommandInput = new RunCommandInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("commandId".equals(fieldName)) {
                    deserializedRunCommandInput.commandId = reader.getString();
                    continue;
                }
                if ("script".equals(fieldName)) {
                    List script;
                    deserializedRunCommandInput.script = script = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    List parameters;
                    deserializedRunCommandInput.parameters = parameters = reader.readArray(reader1 -> RunCommandInputParameter.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRunCommandInput;
        });
    }
}

