/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.OSVersionInner;
import java.io.IOException;
import java.util.List;

public final class OSVersionListResult
implements JsonSerializable<OSVersionListResult> {
    private List<OSVersionInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(OSVersionListResult.class);

    public List<OSVersionInner> value() {
        return this.value;
    }

    public OSVersionListResult withValue(List<OSVersionInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public OSVersionListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model OSVersionListResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static OSVersionListResult fromJson(JsonReader jsonReader) throws IOException {
        return (OSVersionListResult)jsonReader.readObject(reader -> {
            OSVersionListResult deserializedOSVersionListResult = new OSVersionListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedOSVersionListResult.value = value = reader.readArray(reader1 -> OSVersionInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedOSVersionListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOSVersionListResult;
        });
    }
}

